% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_tts_auth.R
\name{ms_get_tts_key}
\alias{ms_get_tts_key}
\alias{ms_have_tts_key}
\alias{ms_set_tts_key}
\alias{ms_valid_tts_key}
\title{Find API Key for Microsoft Text To Speech (TTS) or Cognitive
Services}
\usage{
ms_get_tts_key(api_key = NULL, error = TRUE)

ms_have_tts_key(api_key = NULL)

ms_set_tts_key(api_key)

ms_valid_tts_key(api_key = NULL, region = ms_regions())
}
\arguments{
\item{api_key}{Microsoft Cognitive Services API key}

\item{error}{Should the function error if \code{api_key = NULL}?}

\item{region}{Subscription region for your key.
See
\url{https://learn.microsoft.com/en-us/azure/cognitive-services/speech-service/overview}}
}
\value{
API key
}
\description{
Determines if \code{option(ms_tts_key)} or
\code{option(ms_tts_key)} is set.
If not, it stops and returns an error.  If so, returns the value.
}
\note{
You can either set the API key using
\code{option(ms_tts_key)} or have it accessible by
\code{api_key = Sys.getenv('MS_TTS_API_KEY")}, or
\code{api_key = Sys.getenv('MS_TTS_API_KEY1")}, or
\code{api_key = Sys.getenv('MS_TTS_API_KEY2")}
}
\examples{
res = ms_get_tts_key(error = FALSE)
}
