% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{mspca}
\alias{mspca}
\title{Multiple Sparse PCA}
\usage{
mspca(
  Sigma,
  r,
  ks,
  maxIter = 200L,
  verbose = TRUE,
  feasibilityConstraintType = 0L,
  feasibilityTolerance = 1e-04,
  stallingTolerance = 1e-08,
  maxIterTPW = 200L,
  timeLimitTPW = 20L
)
}
\arguments{
\item{Sigma}{A matrix. The correlation or covariance matrix, whose sparse PCs will be computed.}

\item{r}{An integer. Number of principal components (PCs) to be computed.}

\item{ks}{A list of integers. Target sparsity of each PC.}

\item{maxIter}{(optional) An integer. Maximum number of iterations of the algorithm. Default 200.}

\item{verbose}{(optional) A Boolean. Controls console output. Default TRUE.}

\item{feasibilityConstraintType}{(optional) An integer. Type of feasibility constraints to be enforced. 0: orthogonality constraints; 1: uncorrelatedness constraints. Default 0.}

\item{feasibilityTolerance}{(optional) A float. Tolerance for the violation of the orthogonality constraints. Default 1e-4}

\item{stallingTolerance}{(optional) A float. Controls the objective improvement below which the algorithm is considered to have stalled. Default 1e-8}

\item{maxIterTPW}{(optional) An integer. Maximum number of iterations of the truncated power method (inner iteration). Default 200.}

\item{timeLimitTPW}{(optional) An integer. Maximum time in seconds for the truncated power method (inner iteration). Default 20.}
}
\value{
An object with 4 fields: `x_best` (p x r array containing the sparse PCs), `objective_value`, `feasibility_violation`, `runtime`.
}
\description{
Returns multiple sparse principal component of a matrix using an iterative deflation heuristic.
}
\examples{
library(datasets)
TestMat <- cor(datasets::mtcars)
mspca(TestMat, 2, c(4,4))
}
