% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sens_run.R
\name{sens_run}
\alias{sens_run}
\title{Run ad-hoc parameter sensitivity analyses with mrgsolve}
\usage{
sens_run(
  mod,
  par = NULL,
  var = NULL,
  method = c("factor", "cv", "range", "manual"),
  vary = c("each", "grid"),
  ...,
  sargs = list()
)
}
\arguments{
\item{mod}{a mrgsolve model object.}

\item{par}{parameter names for sensitivity analysis; this can be
a character vector or a comma-separated string (see examples).}

\item{var}{names of model output variables to include in simulated output;
this could be the name of a compartment or another output derived inside
of the model (e.g. \code{DV} or \code{CP} or \code{logV}, but is specific to what is coded
into \code{mod}).}

\item{method}{parameter sequence generation method.}

\item{vary}{use \code{each} to vary one parameter at a time or \code{grid} to vary
all combinations of parameters.}

\item{...}{passed to \code{method} function.}

\item{sargs}{a named list of arguments passed to \code{\link[=sens_each]{sens_each()}} or
\code{\link[=sens_grid]{sens_grid()}} and eventually to \code{\link[mrgsolve:mrgsim]{mrgsolve::mrgsim()}}.}
}
\description{
Run ad-hoc parameter sensitivity analyses with mrgsolve
}
\examples{
mod <- mrgsolve::house()

dose <- mrgsolve::ev(amt = 100)

sens_run(
  mod, 
  par = "CL,VC", 
  method = "cv", 
  vary = "each", 
  sargs = list(events = dose)
)

}
