% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrct_functions.R
\name{mrct.sparse.plot}
\alias{mrct.sparse.plot}
\title{Plot function for result from \code{\link[=mrct.sparse]{mrct.sparse()}}}
\usage{
mrct.sparse.plot(
  x = seq(0, 1, length.out = dim(mrct.sparse.object[[2]])[2]),
  mrct.sparse.object
)
}
\arguments{
\item{x}{Gridpoints on which the smoothed data is to be plotted on. Default is \code{seq(0,1,length.out=new.p)} whereas \code{new.p} is a parameter set in the call to \code{\link[=mrct.sparse]{mrct.sparse()}}.}

\item{mrct.sparse.object}{A result from a call to \code{\link[=mrct.sparse]{mrct.sparse()}}.}
}
\value{
Descriptive plots.
\item{aMHD.plot}{Alpha-Mahalanobis distances, corresponding cutoff values and coloring according to estimated outliers (grey regular, black irregular).}
\item{aMHD.plot.w}{Same as \code{aMHD.plot}, with additional re-weighting step.}
\item{data.plot}{Plot of the smoothed curves, colors corresponding to estimated outliers (gery regular, black irregular). Per default, the x-axis is plotted over
an equidistant grid of the interval \eqn{[0,1]}. }
}
\description{
A function for descriptive plots for an object resulting from a call to \code{\link[=mrct.sparse]{mrct.sparse()}}.
}
\examples{
# Similar to example in mrct.sparse() helpfile
# Fix seed for reproducibility
set.seed(123)

# Sample outlying indices
cont.ind <- sample(1:50,size=10)

# Generate 50 sparse curves on the interval [0,1] at 10 timepoints with 20\% outliers
y <- mrct.rgauss(x.grid=seq(0,1,length.out=10), N=50, model=1,
                 outliers=cont.ind, method="linear")

# Visualize curves (regular curves grey, outliers black)
colormap <- rep("grey",50); colormap[cont.ind] <- "black"
matplot(x = seq(0,1,length.out=10), y = t(y), type="l", lty="solid",
        col=colormap, xlab="t",ylab="")

# Run sparse MRCT
sparse.mrct.y <- mrct.sparse(data = y, nbasis = 10, h = 0.75, new.p = 50,
                             alpha = 0.1, initializations = 10, criterion = "sum" )

# Visualize alpha-Mahalanobis distances and smoothed curves
# Colorinformation according to estimated outliers (grey regular, black irregular)
mrct.sparse.plot(mrct.sparse.object = sparse.mrct.y)

}
