% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QTL_effect_main_QxEC.R
\name{QTL_effect_main_QxEC}
\alias{QTL_effect_main_QxEC}
\title{Estimation of a model with main and QTL by environmental sensitivity terms}
\usage{
QTL_effect_main_QxEC(
  mppData,
  trait,
  env_id = NULL,
  ref_env = NULL,
  ref_par = NULL,
  VCOV = "UN",
  QTL = NULL,
  thre_QTL = 2,
  EC,
  Qmain_QEI = NULL,
  maxIter = 100,
  msMaxIter = 100
)
}
\arguments{
\item{mppData}{An object of class \code{mppData}.}

\item{trait}{\code{Character vector} specifying which traits (environments) should be used.}

\item{env_id}{\code{Character} vector specifying the environment names.
By default, E1, ... En}

\item{ref_env}{Optional \code{Character} expression defining the environment
that will be used as reference for the parental model. By default, the last
environment is set as reference.}

\item{ref_par}{Optional \code{Character} expression defining the parental
allele that will be used as reference for the parental model. By default,
the parent with the largest MAF is set as reference.}

\item{VCOV}{VCOV \code{Character} expression defining the type of variance
covariance structure used. 'CS' for compound symmetry assuming a unique
genetic covariance between environments. 'CSE' for cross-specific within
environment error term. 'CS_CSE' for both compound symmetry plus
cross-specific within environment error term. 'UN' for unstructured
environmental variance covariance structure allowing a specific genotypic
covariance for each pair of environments. Default = 'UN'}

\item{QTL}{Object of class \code{QTLlist} representing a list of
selected marker positions obtained with the function QTL_select() or
a vector of \code{character} marker positions names. Default = NULL.}

\item{thre_QTL}{\code{Numerical} value specifying the -log10(p-val) threshold
for a parental QTL allele to be considered as significant. By default,
thre_QTL = 2, which correspond to a p-value of 0.01.}

\item{EC}{\code{Numeric} matrix with environments as row and environmental
covariates (EC) as column. The cell i, j of EC specify the value of the
jth EC in environment i.}

\item{Qmain_QEI}{results from \code{\link{QTL_effect_main_QEI}}}

\item{maxIter}{maximum number of iterations for the lme optimization algorithm.
Default = 100.}

\item{msMaxIter}{maximum number of iterations for the optimization step inside
the lme optimization. Default = 100.}
}
\value{
Return:

\code{List} with one \code{data.frame} per QTL that contains the following
elements:

\enumerate{

\item{QTL parent allele main effect expressed as deviation with respect to
the reference parent}
\item{QTL parent allele effect in environment j expressed as deviation with
respect to the reference parent}
\item{Significance of the parent main effect expressed as the -log10(p-val)}

\item{Significance of the parent QTLxE effect expressed as the -log10(p-val)}

}
}
\description{
After estimating which parental allelic effects have a significant interaction
with the environment (QEI), the function extends the model for the allelic
effect with a significant QEI to characterize this interaction in terms of
sensitivity to (a) specific environmental covariate(s).
}
\details{
The function first estimate the parental QTL allele main and QTLxE effect
using the function \code{\link{QTL_effect_main_QEI}}. Optionally the output
of \code{\link{QTL_effect_main_QEI}} can be passed through the `Qmain_QEI`
argument. The function consider that a parental QTL allele significantly
interacts with the environment if its QTLxE term is significant at the
`thre_QTL` level. Thre_QTL is expressed in terms of -log10(p-val).
For example, for p-val = 0.01, thre_QTL = -log10(p-val) = 2. Given this
information, the effect of the parental QTL allele with a significant QEI
are extended like that \eqn{\beta_{pj} = EC_j*S_p+l_{p\epsilon}} where
\eqn{EC_j} represents the EC value in environment j associated with the
sensitivity term \eqn{S_p}. The \eqn{S_{p}} determines the rate of change of
the parental QTL allelic additive effect given an extra unit of EC. Finally,
\eqn{l_{p\epsilon}} is a residual effect. The fitted model becomes:

\eqn{\underline{y}_{icj} = E_{j} + C_{cj} + \sum_{q=1}^{n_{QTL}} x_{i_{q}p} (\alpha_p + \beta_{pj}) + x_{i_{q}pxE} (\alpha_p + EC_j*S_p+l_{p\epsilon}) + \underline{GE}_{icj} + \underline{e}_{icj}}

The estimation is performed using an exact mixed model with function from R
package \code{nlme}. The significance of \eqn{S_{p}} is assessed using a 
Wald test.
}
\examples{

\dontrun{

data(mppData_GE)

Qpos <- c("PZE.105068880", "PZE.106098900")

EC <- matrix(c(180, 310, 240, 280), 4, 1)
rownames(EC) <- c('CIAM', 'TUM', 'INRA', 'KWS')
colnames(EC) <- 'cum_rain'

Qeff <- QTL_effect_main_QxEC(mppData = mppData_GE,
                         trait = c('DMY_CIAM', 'DMY_TUM', 'DMY_INRA_P', 'DMY_KWS'),
                         env_id = c('CIAM', 'TUM', 'INRA', 'KWS'),
                         QTL = Qpos, EC = EC)

Qeff

}

}
\references{
Pinheiro J, Bates D, DebRoy S, Sarkar D, R Core Team (2021). nlme: Linear
and Nonlinear Mixed Effects Models_. R package version 3.1-152,
<URL: https://CRAN.R-project.org/package=nlme>.
}
\seealso{
\code{\link{QTL_effect_main_QEI}}
}
\author{
Vincent Garin
}
