% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timezone_helpers.R
\name{add_timezones_to_db}
\alias{add_timezones_to_db}
\title{Add timezone to measurements in an m-Path Sense database}
\usage{
add_timezones_to_db(db, sensors = NULL, .progress = TRUE)
}
\arguments{
\item{db}{A database connection, typically created by \code{\link[=open_db]{open_db()}}.}

\item{sensors}{A character vector of sensor table names to update. Defaults to \code{NULL} for all supported
sensors.}

\item{.progress}{Logical; whether to show a progress bar during processing. Defaults to \code{TRUE}.}
}
\value{
Invisibly returns \code{TRUE} if all updates complete successfully.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function looks for a \code{Timezone} table in a local m-Path Sense SQLite database and uses it
to assign timezone values to all other sensor tables. For each observation in a sensor table,
it finds the timezone interval that matches the observation's timestamp and adds or updates a
\code{timezone} column accordingly.
}
\details{
Note that rerunning this function overwrites existing \code{timezone} columns in the sensor tables.
Also note that if a measurement matches multiple time zones (i.e. a timezone change occurred
during the measurement), the timezone with the longest overlap is chosen.
}
\examples{
\dontrun{
# Connect to an m-Path Sense database
db <- open_db("path/to/db.sqlite")

# Add timezone information to all tables
add_timezones_to_db(db)

# Disconnect when done
close_db(db)
}

}
