% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpae_package.R
\docType{data}
\name{bfan}
\alias{bfan}
\title{Above normal body fat data}
\format{
A data frame with 246 rows and 16 columns:
\describe{
\item{bfan}{Body fat above normal range}
\item{age}{Age (years)}
\item{weight}{Weight (kg)}
\item{height}{Height (cm)}
\item{neck}{Neck circumference (cm)}
\item{chest}{Chest circumference (cm)}
\item{abdomen}{Abdomen circumference (cm)}
\item{hip}{Hip circumference (cm)}
\item{thigh}{Thigh circumference (cm)}
\item{knee}{Knee circumference (cm)}
\item{ankle}{Ankle circumference (cm)}
\item{biceps}{Biceps (extended) circumference (cm)}
\item{forearm}{Forearm circumference (cm)}
\item{wrist}{Wrist circumference (cm)}
\item{bmi}{Body mass index (kg/m2)}
\item{bmi2}{Alternate body mass index}
}
}
\source{
StatLib Datasets Archive: \url{https://lib.stat.cmu.edu/datasets/bodyfat}.
}
\usage{
bfan
}
\description{
Modification of the \code{\link{bodyfat}} dataset for classification.
The response \code{bfan} is a factor indicating a body fat value above the normal
range.
The variable \code{bodyfat} was dropped for convenience, and two new variables
\code{bmi} (body mass index, in kg/m^2) and \code{bmi2} (alternate body mass index,
in kg^1.2/m^3.3) were computed (see examples below).
}
\details{
See \code{\link{bodyfat}} and \code{\link{bodyfat.raw}} for details.
}
\examples{
bfan <- bodyfat
# Body fat above normal
bfan[1] <- factor(bfan$bodyfat > 24 , # levels = c('FALSE', 'TRUE'),
                labels = c('No', 'Yes'))
names(bfan)[1] <- "bfan"
bfan$bmi <- with(bfan, weight/(height/100)^2)
bfan$bmi2 <- with(bfan, weight^1.2/(height/100)^3.3)

fit <- glm(bfan ~ abdomen, family = binomial, data = bfan)
summary(fit)
}
\references{
Penrose, K., Nelson, A. and Fisher, A. (1985). Generalized Body Composition
Prediction Equation for Men Using Simple Measurement Techniques.
\emph{Medicine and Science in Sports and Exercise}, 17(2), 189.
\doi{10.1249/00005768-198504000-00037}.
}
\seealso{
\code{\link{bodyfat}}, \code{\link{bodyfat.raw}}
}
\keyword{datasets}
