% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpae_package.R
\docType{data}
\name{bodyfat}
\alias{bodyfat}
\title{Body fat data}
\format{
A data frame with 246 rows and 14 columns:
\describe{
\item{bodyfat}{Percent body fat (from Siri's 1956 equation)}
\item{age}{Age (years)}
\item{weight}{Weight (kg)}
\item{height}{Height (cm)}
\item{neck}{Neck circumference (cm)}
\item{chest}{Chest circumference (cm)}
\item{abdomen}{Abdomen circumference (cm)}
\item{hip}{Hip circumference (cm)}
\item{thigh}{Thigh circumference (cm)}
\item{knee}{Knee circumference (cm)}
\item{ankle}{Ankle circumference (cm)}
\item{biceps}{Biceps (extended) circumference (cm)}
\item{forearm}{Forearm circumference (cm)}
\item{wrist}{Wrist circumference (cm)}
}
}
\source{
StatLib Datasets Archive: \url{https://lib.stat.cmu.edu/datasets/bodyfat}.
}
\usage{
bodyfat
}
\description{
Modification of the dataset analysed in Penrose et al. (1985).
Lists estimates of the percentage of body fat determined by underwater weighing
and various body measurements for 246 men.
}
\details{
This data set can be used to illustrate multiple regression techniques
(e.g. Johnson 1996).
Instead of estimating body fat percentage from body density, which is not
easy to measure, it is desirable to have a simpler method that allow this to
be done from body measurements.

\code{\link{bodyfat.raw}} contains the original data.
According to Johnson (1996), there were data entry errors (cases 42, 48, 76,
96 and 182 of the original data) and he suggested some rules to correct them.
These outliers were removed in the \code{bodyfat} dataset, as well as an influential
observation (case 39, which has a big effect on regression estimates).
Additionally, the variable \code{density} was dropped for convenience, and variables
\code{height} and \code{weight} were transformed into metric units (centimetres and
kilograms) for consistency.

See \code{\link{bodyfat.raw}} for more details.
}
\examples{
fit <- lm(bodyfat ~ abdomen, bodyfat)
summary(fit)
plot(bodyfat ~ abdomen, bodyfat)
abline(fit)
}
\references{
Johnson, R. W. (1996). Fitting Percentage of Body Fat to Simple Body
Measurements. \emph{Journal of Statistics Education}, 4(1).
\doi{10.1080/10691898.1996.11910505}.

Penrose, K., Nelson, A. and Fisher, A. (1985). Generalized Body Composition
Prediction Equation for Men Using Simple Measurement Techniques.
\emph{Medicine and Science in Sports and Exercise}, 17(2), 189.
\doi{10.1249/00005768-198504000-00037}.
}
\seealso{
\code{\link{bodyfat.raw}}, \code{\link{bfan}}
}
\keyword{datasets}
