% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_max_acceleration.R
\name{index_max_acceleration}
\alias{index_max_acceleration}
\title{Time point of maximum acceleration}
\usage{
index_max_acceleration(x_vector, y_vector, absolute = FALSE)
}
\arguments{
\item{x_vector}{x-coordinates of the executed path.}

\item{y_vector}{y-coordinates of the executed path.}

\item{absolute}{Should negative accelerations (i.e., deceleration)
be included? Defaults to \code{FALSE}.}
}
\value{
Single number indicating the index of peak acceleration (1 to +Inf).
}
\description{
Computes the index of the peak acceleration of a trajectory,
defined by vectors of x and y coordinates, and assumed to be equidistant
in time.
}
\details{
The supplied vectors are assumed to be ordered by time with equal
time differences.
}
\examples{
x_vals <- c(0, 1, 2, 3, 6, 10, 12, 14, 15)
y_vals <- c(0, 0, 0, 0, 0, 0, 0, 0, 0)
index_max_acceleration(x_vals, y_vals)
# acceleration maximal between x_vals[4] and x_vals[5]

}
\references{
Wirth, R., Foerster, A., Kunde, W., & Pfister, R. (2020).
Design choices: Empirical recommendations for designing two-dimensional
finger tracking experiments. Behavior Research Methods, 52, 2394 - 2416.
\doi{10.3758/s13428-020-01409-0}
}
