% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/direction_changes.R
\name{direction_changes}
\alias{direction_changes}
\title{xFlips}
\usage{
direction_changes(numeric_vector)
}
\arguments{
\item{numeric_vector}{Numbers, ordered by their time of appearance.}
}
\value{
Single number indicating how often \code{numeric_vector}
changes direction (0 to +Inf).
}
\description{
Checks how often a number sequence changes from decreasing
monotonically to increasing monotonically (or vice versa).
}
\details{
The supplied vectors are assumed to be ordered by time.
Values do not have to be strictly monotonically in-/decreasing.
I.e., \code{c(0, 1, 1, 2)} would return 0,
as \eqn{x_n >= x_n-1} is satisfied for \eqn{2 <= n <= length(c(0, 1, 1, 2))}.
}
\examples{
direction_changes(c(0, 1, 1, 2))
direction_changes(c(0, 1, 1, 0))
direction_changes(c(0, 1, 0, 1))

}
\references{
Wirth, R., Foerster, A., Kunde, W., & Pfister, R. (2020).
Design choices: Empirical recommendations for designing two-dimensional
finger tracking experiments. Behavior Research Methods, 52, 2394 - 2416.
\doi{10.3758/s13428-020-01409-0}
}
