% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zscore_mu_synch.R
\name{zscore_mu_synch}
\alias{zscore_mu_synch}
\title{Determination of Motor Unit Synchronization from Cross Correlation Histograms
using the Z-score Method}
\usage{
zscore_mu_synch(motor_unit_1, motor_unit_2, order = 1, binwidth =
  0.001, get_data = T, plot = F)
}
\arguments{
\item{motor_unit_1, motor_unit_2}{Numeric vectors of strictly increasing
numbers denoting sequential discharge times of a motor unit or neuron or
any strictly increasing point process.}

\item{order}{Numeric as a positive integer for the number of forward and
backward orders for calculating recurrence times. Default = 1.}

\item{binwidth}{Numeric as a positive for the bin allocation size for
computational histogram. Default = 0.001 or 1 ms.}

\item{get_data}{T/F logical for outputting motor unit data. Default is TRUE.}

\item{plot}{T/F logical for outputting the cross correlation histogram.
Default is FALSE.}
}
\value{
A list of lists containing motor unit data (the names of each
  discharge train used, number of discharges, the interspike intervals (ISI),
  mean ISI, and the recurrence times associated with each order) and
  synchronization indices.
  CIS = frequency of synchronized discharges.
  k' = ratio of total discharges in peak to expected discharges in peak.
  k'-1 = ratio of synchronized discharges to expected discharges in peak.
  S = ratio of synchronized discharges to total number of discharges of both
  motor units.
  E = ratio of synchronized discharges to non-synchronized discharges.
  SI = ratio of synchronized discharges to reference motor unit discharges.
}
\description{
Calculates the time-domain synchronization indices CIS, k',
  k'-1, S, E, SI (detailed below) between the two input motor unit discharge
  trains based on the z-score method. First, a random uniform distribution is
  used to calculate a mean + 1.96 * standard deviation threshold for the
  experimental cross correlation histogram. Any bins within +/- 10 ms of 0
  that crosses the threshold are considered to be significantly greater than
  expected due to chance and subsequently used for analysis. If no peaks are
  detected, synchronization indices of 0 are returned. Because the z-score
  method tests each bin individually, peak bins are not necessarily adjacent.
  Therefore, peak duration and peak center are returned as NA.
}
\examples{
  x <- c(0.035, 0.115, 0.183, 0.250, 0.306, 0.377, 0.455, 0.512, 0.577,
  0.656, 0.739, 0.821, 0.866, 0.950, 1.014, 1.085, 1.153, 1.213, 1.279,
  1.355, 1.431, 1.482, 1.551, 1.631, 1.692, 1.749, 1.832, 1.897, 1.964,
  2.106, 2.149, 2.229, 2.302, 2.384, 2.420, 2.505, 2.592, 2.644, 2.722,
  2.801, 2.870, 2.926, 3.011, 3.098, 2.030, 3.183, 3.252, 3.319, 3.395,
  3.469, 3.560, 3.589, 3.666, 3.744, 3.828, 3.876, 3.943, 4.020, 4.104)
  x <- sort(x)
  y <- sort(jitter(x))
  y <- round(y, digits = 3)
  zscore_mu_synch(x, y, order = 1, binwidth = 0.001, get_data = TRUE,
  plot = FALSE)
}
\references{
DeFreitas, J.M., Beck, T.W., Xin, Y., Stock, M.S. (2013)
  Synchronization of Low- and High-Threshold Motor Units. Muscle & Nerve DOI
  10.1002/mus.23978
}
\keyword{motor}
\keyword{recurrence,}
\keyword{synchronization,}
\keyword{unit,}
\keyword{z-score}
