% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fns.R
\name{read_csv}
\alias{read_csv}
\title{Read a CSV file into a DuckDB/MotherDuck table}
\usage{
read_csv(
  .con,
  to_database_name,
  to_schema_name,
  to_table_name,
  file_path,
  header,
  all_varchar,
  sample_size,
  names,
  types,
  skip,
  union_by_name,
  normalize_names,
  allow_quoted_nulls,
  ignore_errors,
  write_type,
  ...
)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}

\item{to_database_name}{Target database name (new or existing)}

\item{to_schema_name}{Target schema name  (new or existing)}

\item{to_table_name}{Target table name to create  (new or existing)}

\item{file_path}{Path to the Excel file (\code{.xlsx})}

\item{header}{Logical; if \code{TRUE}, first row is header}

\item{all_varchar}{Logical; coerce all columns to \code{VARCHAR}}

\item{sample_size}{Numeric; number of rows used for type inference}

\item{names}{Character vector; optional column names to assign instead of reading from the file}

\item{types}{Named or unnamed character vector; column types (named preferred, unnamed paired to \code{names})}

\item{skip}{Integer; number of rows to skip at the beginning of the file}

\item{union_by_name}{Logical; union multiple CSVs by column name}

\item{normalize_names}{Logical; normalize column names (lowercase, replace spaces)}

\item{allow_quoted_nulls}{Logical; treat \code{"NULL"} in quotes as NULL}

\item{ignore_errors}{Logical; continue on row parse errors}

\item{write_type}{Character; either \code{"overwrite"} or \code{"append"}, controls table creation behavior}

\item{...}{Additional arguments passed to \code{read_csv_auto()} in format listed in duckdb documentation (optional)}
}
\value{
Invisibly returns \code{NULL}. Side effect: creates \verb{<database>.<schema>.<table>} with the CSV data
}
\description{
Loads the DuckDB \strong{excel} extension and creates a table from a CSV file
using the \code{read_csv_auto()} table function. The destination is fully qualified
as \verb{<database>.<schema>.<table>}. Only the options you supply are forwarded
to \code{read_csv_auto()} (e.g., \code{header}, \code{all_varchar}, \code{sample_size},
\code{names}, \code{types}, \code{skip}, \code{union_by_name}, \code{normalize_names},
\code{allow_quoted_nulls}, \code{ignore_errors}). If \code{names} or \code{types} are not supplied,
they are ignored. See the DuckDB \href{https://duckdb.org/docs/stable/data/csv/overview}{read_csv_auto() documentation} for more information.
}
\seealso{
Other db-read: 
\code{\link{read_excel}()}
}
\concept{db-read}
