test_that("loading dataset", {
    expect_no_error({data("cadmium1")})
    expect_no_error(data("cadmium2"))
    expect_no_error(data("chlordan"))
    expect_no_error(data("copper"))
    expect_no_error(data("dichromate"))
    expect_no_error(data("propiconazole"))
    expect_no_error(data("zinc"))
    # Continuous
    expect_no_error(data("cadmium_daphnia"))
    expect_no_error(data("chlordan_daphnia"))
    expect_no_error(data("copper_daphnia"))
    expect_no_error(data("zinc_daphnia"))
    expect_no_error(data("subst01_lymnaea"))
    expect_no_error(data("plant01"))
    expect_no_error(data("plant02"))
    expect_no_error(data("plant03"))
    expect_no_error(data("plant04"))
    expect_no_error(data("plant05"))
    expect_no_error(data("plant06"))
    expect_no_error(data("plant07"))
    expect_no_error(data("plant08"))
    expect_no_error(data("plant09"))
    expect_no_error(data("plant10"))
})

test_that("BinaryData", {
    expect_true(nrow(binaryDataCheck(cadmium1)) == 0)
    expect_true(nrow(binaryDataCheck(cadmium2)) == 0)
    expect_true(nrow(binaryDataCheck(chlordan)) == 0)
    expect_true(nrow(binaryDataCheck(copper)) == 0)
    expect_true(nrow(binaryDataCheck(dichromate)) == 0)
    expect_true(nrow(binaryDataCheck(propiconazole)) == 0)
    expect_true(nrow(binaryDataCheck(zinc)) == 0)
})

test_that("CountData", {
    expect_true(nrow(countDataCheck(cadmium1)) == 0)
    expect_true(nrow(countDataCheck(cadmium2)) == 0)
    expect_true(nrow(countDataCheck(chlordan)) == 0)
    expect_true(nrow(countDataCheck(copper)) == 0)
    expect_true(nrow(countDataCheck(zinc)) == 0)

})

test_that("ContinuousData", {
    expect_true(nrow(continuousDataCheck(cadmium_daphnia)) == 0)
    expect_true(nrow(continuousDataCheck(chlordan_daphnia)) == 0)
    expect_true(nrow(continuousDataCheck(copper_daphnia)) == 0)
    expect_true(nrow(continuousDataCheck(zinc_daphnia)) == 0)
    expect_true(nrow(continuousDataCheck(subst01_lymnaea)) == 0)
    expect_true(nrow(continuousDataCheck(plant01)) == 0)
    expect_true(nrow(continuousDataCheck(plant02)) == 0)
    expect_true(nrow(continuousDataCheck(plant03)) == 0)
    expect_true(nrow(continuousDataCheck(plant04)) == 0)
    expect_true(nrow(continuousDataCheck(plant05)) == 0)
    expect_true(nrow(continuousDataCheck(plant06)) == 0)
    expect_true(nrow(continuousDataCheck(plant07)) == 0)
    expect_true(nrow(continuousDataCheck(plant08)) == 0)
    expect_true(nrow(continuousDataCheck(plant09)) == 0)
    expect_true(nrow(continuousDataCheck(plant10)) == 0)
})
