% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hv_approx.R
\name{hv_approx}
\alias{hv_approx}
\title{Approximate the hypervolume indicator.}
\usage{
hv_approx(
  x,
  reference,
  maximise = FALSE,
  nsamples = 100000L,
  seed = NULL,
  method = c("DZ2019-HW", "DZ2019-MC")
)
}
\arguments{
\item{x}{\code{matrix()}|\code{data.frame()}\cr Matrix or data frame of numerical
values, where each row gives the coordinates of a point.}

\item{reference}{\code{numeric()}\cr Reference point as a vector of numerical
values.}

\item{maximise}{\code{logical()}\cr Whether the objectives must be maximised
instead of minimised. Either a single logical value that applies to all
objectives or a vector of logical values, with one value per objective.}

\item{nsamples}{\code{integer(1)}\cr Number of samples for Monte-Carlo sampling.}

\item{seed}{\code{integer(1)}\cr Random seed.}

\item{method}{\code{character(1)}\cr Method to generate the sampling weights. See `Details'.}
}
\value{
A single numerical value.
}
\description{
Approximate the value of the hypervolume metric with respect to a given
reference point assuming minimization of all objectives. The default
\code{method="DZ2019-HW"} is deterministic and ignores the parameter \code{seed},
while \code{method="DZ2019-MC"} relies on Monte-Carlo sampling
\citep{DenZha2019approxhv}.  Both methods tend to get more accurate with
higher values of \code{nsamples}, but the increase in accuracy is not monotonic.
}
\details{
This function implements the method proposed by \citet{DenZha2019approxhv}
to approximate the hypervolume:

\deqn{\widehat{HV}_r(A) = \frac{2\pi^\frac{m}{2}}{\Gamma(\frac{m}{2})}\frac{1}{m 2^m}\frac{1}{n}\sum_{i=1}^n \max_{y \in A} s(w^{(i)}, y)^m}

where \eqn{m} is the number of objectives, \eqn{n} is the number of weights
\eqn{w^{(i)}} sampled, \eqn{\Gamma()} is the gamma function \code{\link[=gamma]{gamma()}}, i.e.,
the analytical continuation of the factorial function, and \eqn{s(w, y) =
\min_{k=1}^m (r_k - y_k)/w_k}.

In the default \code{method="DZ2019-HW"}, the weights \eqn{w^{(i)}, i=1\ldots n}
are defined using a deterministic low-discrepancy sequence. The weight
values depend on their number (\code{nsamples}), thus increasing the number of
weights may not necessarily increase accuracy because the set of weights
would be different. In \code{method="DZ2019-MC"}, the weights
\eqn{w^{(i)}, i=1\ldots n} are sampled from the unit normal vector such that
each weight \eqn{w = \frac{|x|}{\|x\|_2}} where each component of \eqn{x} is
independently sampled from the standard normal distribution.  The original
source code in C++/MATLAB for both methods can be found at
\url{https://github.com/Ksrma/Hypervolume-Approximation-using-polar-coordinate}.
}
\references{
\insertAllCited{}
}
\author{
Manuel \enc{López-Ibáñez}{Lopez-Ibanez}
}
\concept{metrics}
\examples{
x <- matrix(c(5, 5, 4, 6, 2, 7, 7, 4), ncol=2, byrow=TRUE)
hypervolume(x, ref=10)
hv_approx(x, ref=10, seed=42, method="DZ2019-MC")
hv_approx(x, ref=10, method="DZ2019-HW")
}
