% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monotone.R
\name{monotone}
\alias{monotone}
\title{Monotone Regression Function}
\usage{
monotone(x, w = rep(1, length(x)))
}
\arguments{
\item{x}{a real-valued vector.}

\item{w}{a real-valued vector with positive weights (default a vector with ones).}
}
\value{
Returns a real-valued vector with values of \code{x} in increasing order.
}
\description{
\code{monotone} performs simple linear ordered monotone or isotonic regression.
The function follows the up-and-down-blocks implementation (Kruskal, 1964)
of the pool-adjacent-violators algorithm (Ayer, Brunk, Ewing, Reid, and Silverman, 1955)
with additional lookaheads (Busing, 2022).
}
\details{
Error checking on \code{x} or \code{w} is not present.
}
\examples{
y <- c( 8, 4, 8, 2, 2, 0, 8 )
x <- monotone( y )
print( x )

}
\references{
Ayer M., H.D. Brunk, G.M. Ewing, W.T. Reid, and E. Silverman (1955). 
  An empirical distribution function for sampling with incomplete information. 
  \emph{The Annals of Mathematical Statistics}, pp. 641-647. 
  URL https://www.jstor.org/stable/pdf/2236377.pdf.

  Busing, F.M.T.A. (2022). 
  Monotone Regression: A Simple and Fast O(n) PAVA Implementation. 
  \emph{Journal of Statistical Software, Code Snippets, 102 (1)}, pp. 1-25. 
  (<doi:10.18637/jss.v102.c01>)
  

  Kruskal, J.B. (1964). 
  Nonmetric multidimensional scaling: a numerical method.
  \emph{Psychometrika, 29(2)}, pp. 115-129. 
  URL http://cda.psych.uiuc.edu/psychometrika_highly_cited_articles/kruskal_1964b.pdf.
}
