% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na-warn.R
\name{na.warn}
\alias{na.warn}
\title{Handle missing values with a warning}
\usage{
na.warn(object)
}
\arguments{
\item{object}{A data frame}
}
\description{
This NA handler ensures that those models that support the
\code{na.action} parameter do not silently drop missing values. It
wraps around \code{\link[stats:na.fail]{stats::na.exclude()}} so that there is one
prediction/residual for input row. To apply it globally, run
\code{options(na.action = na.warn)}.
}
\examples{
df <- tibble::tibble(
  x = 1:10,
  y = c(5.1, 9.7, NA, 17.4, 21.2, 26.6, 27.9, NA, 36.3, 40.4)
)
# Default behaviour is to silently drop
m1 <- lm(y ~ x, data = df)
resid(m1)

# Use na.action = na.warn to warn
m2 <- lm(y ~ x, data = df, na.action = na.warn)
resid(m2)
}
