% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_cimrob.R
\name{fail_drop}
\alias{fail_drop}
\title{Handle Model Fitting Failures and Variable Dropping}
\usage{
fail_drop(drop, fail, clust.mod, ind_variables)
}
\arguments{
\item{drop}{Logical; if TRUE, allows the function to return \code{NA} for failed
model fits, otherwise stops execution with an error message.}

\item{fail}{Logical; indicates whether the model fitting process has failed.}

\item{clust.mod}{A model object resulting from cluster-specific fitting.}

\item{ind_variables}{A character vector of independent variable names expected
in the model.}
}
\value{
If \code{fail} is TRUE and \code{drop} is FALSE, the function stops with an
error message.
If \code{fail} is TRUE and \code{drop} is TRUE, it returns \code{NA}.
If \code{fail} is FALSE, it returns the coefficients for the independent
variables in \code{clust.mod}.
}
\description{
This internal function is designed to handle failures in cluster-specific model
fitting and variable dropping issues in the context of cluster-adjusted robust
inference functions. It checks for model fitting failures and whether independent
variables have been dropped in the model.
}
\keyword{internal}
