% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{MV_critical_cp}
\alias{MV_critical_cp}
\title{Statistics-adapted values for extended minimum volatility selection.}
\usage{
MV_critical_cp(
  y,
  X,
  t,
  gridm,
  gridtau,
  cvalue = 0.1,
  B = 100L,
  lrvmethod = 1L,
  ind = 2L,
  rescale = 0L
)
}
\arguments{
\item{y, }{vector, as used in the Heter_LRV}

\item{X, }{matrix, covariates}

\item{t, }{vector, time points.}

\item{gridm, }{vector, a grid of candidate m's.}

\item{gridtau, }{vector, a grid of candidate tau's.}

\item{cvalue, }{double, 1-quantile for the calculation of bootstrap variance, default 0.1.}

\item{B, }{integer, number of iterations for the calculation of bootstrap variance}

\item{lrvmethod, }{integer, see also Heter_LRV}

\item{ind, }{integer, the type of kernel,  see also Heter_LRV}

\item{rescale, }{bool, whether to rescale when positiveness of the matrix is not obtained. default 0}
}
\value{
a matrix of critical values
}
\description{
Smoothing parameter selection for bootstrap tests for change point tests
}
\examples{
n = 300
t = (1:n)/n
data = bregress2(n, 2, 1) # time series regression model with 2 changes points
critical = MV_critical_cp(data$y, data$x,t,  c(3,4,5), c(0.2,0.25, 0.3))
}
\references{
Bai, L., & Wu, W. (2024). Difference-based covariance matrix estimation in time series nonparametric regression with application to specification tests. Biometrika, asae013.
}
