% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskRegr.R
\name{autoplot.TaskRegr}
\alias{autoplot.TaskRegr}
\title{Plots for Regression Tasks}
\usage{
\method{autoplot}{TaskRegr}(object, type = "target", theme = theme_minimal(), ...)
}
\arguments{
\item{object}{(\link[mlr3:TaskRegr]{mlr3::TaskRegr}).}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{theme}{(\code{\link[ggplot2:theme]{ggplot2::theme()}})\cr
The \code{\link[ggplot2:ggtheme]{ggplot2::theme_minimal()}} is applied by default to all plots.}

\item{...}{(ignored).}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
Visualizations for \link[mlr3:TaskRegr]{mlr3::TaskRegr}.
The argument \code{type} controls what kind of plot is drawn.
Possible choices are:
\itemize{
\item \code{"target"} (default): Box plot of the target variable.
\item \code{"pairs"}: Passes data to \code{\link[GGally:ggpairs]{GGally::ggpairs()}}.
Color is set to target column.
}
}
\examples{
if (requireNamespace("mlr3")) {
  library(mlr3)
  library(mlr3viz)

  task = tsk("mtcars")
  task$select(c("am", "carb"))

  head(fortify(task))
  autoplot(task)
  autoplot(task, type = "pairs")
}
}
