% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpFDAWavelets.R
\name{mlr_pipeops_fda.wavelets}
\alias{mlr_pipeops_fda.wavelets}
\alias{PipeOpFDAWavelets}
\title{Discrete Wavelet transform features}
\description{
This \code{PipeOp} extracts discrete wavelet transform coefficients from functional columns.
For more details, see \code{\link[wavelets:dwt]{wavelets::dwt()}}, which is called internally.
}
\section{Parameters}{

The parameters are the parameters inherited from \code{\link[mlr3pipelines:PipeOpTaskPreprocSimple]{PipeOpTaskPreprocSimple}},
as well as the following parameters:
\itemize{
\item \code{filter} :: \code{character(1)} | \code{numeric()} | \code{\link[wavelets:wt.filter]{wavelets::wt.filter()}}\cr
Specifies which filter should be used. Must be either \code{\link[wavelets:wt.filter]{wavelets::wt.filter()}} object, an even numeric vector or a
string. In case of a string must be one of \code{"d"}|\code{"la"}|\code{"bl"}|\code{"c"} followed by an even number for the level of
the filter. The level of the filter needs to be smaller or equal then the time-series length.
For more information and acceptable filters see \code{help(wt.filter)}. Defaults to \code{"la8"}.
\item \code{n.levels} :: \code{integer(1)}\cr
An integer specifying the level of the decomposition.
\item \code{boundary} :: \code{character(1)}\cr
Boundary to be used. \code{"periodic"} assumes circular time series, for \code{"reflection"} the series is extended to twice
its length. Default is \code{"periodic"}.
\item \code{fast} :: \code{logical(1)}\cr
Should the pyramid algorithm be calculated with an internal C function? Default is \code{TRUE}.
}
}

\examples{
task = tsk("fuel")
po_wavelets = po("fda.wavelets")
task_wavelets = po_wavelets$train(list(task))[[1L]]
task_wavelets$data()
}
\section{Super classes}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{\link[mlr3pipelines:PipeOpTaskPreproc]{mlr3pipelines::PipeOpTaskPreproc}} -> \code{\link[mlr3pipelines:PipeOpTaskPreprocSimple]{mlr3pipelines::PipeOpTaskPreprocSimple}} -> \code{PipeOpFDAWavelets}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipeOpFDAWavelets-new}{\code{PipeOpFDAWavelets$new()}}
\item \href{#method-PipeOpFDAWavelets-clone}{\code{PipeOpFDAWavelets$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpFDAWavelets-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpFDAWavelets-new}{}}}
\subsection{Method \code{new()}}{
Initializes a new instance of this Class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpFDAWavelets$new(id = "fda.wavelets", param_vals = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of resulting object, default is \code{"fda.wavelets"}.}

\item{\code{param_vals}}{(named \code{list()})\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would
otherwise be set during construction. Default \code{list()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpFDAWavelets-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpFDAWavelets-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpFDAWavelets$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
