% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_local_influence.R
\name{local_influence.mixpoissonreg}
\alias{local_influence.mixpoissonreg}
\title{Local Influence Diagnostics for Mixed Poisson Regression Models}
\usage{
\method{local_influence}{mixpoissonreg}(
  model,
  perturbation = c("case_weights", "hidden_variable", "mean_explanatory",
    "precision_explanatory", "simultaneous_explanatory"),
  curvature = c("conformal", "normal"),
  direction = c("canonical", "max.eigen"),
  parameters = c("all", "mean", "precision"),
  mean.covariates = NULL,
  precision.covariates = NULL,
  ...
)
}
\arguments{
\item{model}{a \code{mixpoissonreg} object.}

\item{perturbation}{a list or vector of perturbation schemes to be returned. The currently available schemes are
"case_weights", "hidden_variable", "mean_explanatory", "precision_explanatory", "simultaneous_explanatory". See Barreto-Souza and Simas (2016) for further details.}

\item{curvature}{the curvature to be returned, 'conformal' for the conformal normal curvature (see Zhu and Lee, 2001 and Poon and Poon, 1999) or
'normal' (see Zhu and Lee, 2001 and Cook, 1986).}

\item{direction}{the 'max.eigen' returns the eigenvector associated to the largest eigenvalue of the perturbation matrix. The 'canonical' considers
the curvatures under the canonical directions, which is known as "total local curvature" (see Lesaffre and Verbeke, 1998). For conformal
normal curvatures both of them coincide. The default is 'canonical'.}

\item{parameters}{the parameter to which the local influence will be computed. The options are 'all', 'mean' and 'precision'.
This argument affects the 'case_weights' and 'hidden_variable' perturbation schemes. The default is 'all'.}

\item{mean.covariates}{a list or vector of characters containing the mean-explanatory variables to be used in the 'mean-explanatory' and 'simultaneous-explanatory'
perturbation schemes. If NULL, the 'mean-explanatory' and 'simultaneous-explanatory' perturbation schemes will be computed by perturbing all
mean-related covariates. The default is NULL.}

\item{precision.covariates}{a list or vector of characters containing the precision-explanatory variables to be used in the 'precision-explanatory'
and 'simultaneous-explanatory'
perturbation schemes. If NULL, the 'precision-explanatory' and 'simultaneous-explanatory' perturbation schemes will be computed by perturbing all
precision-related covariates. The default is NULL.}

\item{...}{other graphical arguments to be passed.}
}
\value{
a list containing the resulting perturbation schemes as elements. Each returned element has an attribute 'benchmark', which for
the conformal normal curvature, it is computed following Zhu and Lee (2001), and for normal curvature it is computed following Verbeke and ...
If the 'direction' is 'max.eigen' the 'benchmark' attribute is NA.

The 'mean_explanatory', 'precision_explanatory' and 'simultaneous_explanatory' elements of the list contain an attribute 'covariates' indicating
which covariates were used in the perturbation schemes.
}
\description{
This function provides local influence diagnostic quantities. Currently the conformal normal and normal curvatures are available
under several perturbation schemes. The default is the conformal normal curvature since
it takes values on \eqn{[0,1]} and other nice properties (see Zhu and Lee, 2001 and Poon and Poon, 1999 for further details).
}
\details{
\code{local_influence.mixpoissonreg} provides local influence diagnostics for mixed Poisson regression models for all perturbation schemes considered in
Barreto-Souza and Simas (2016), for normal and conformal normal curvatures. Further, it is also provides results for the canonical directions, which is called
the total local influence (see Lesaffre and Verbeke, 1998), as well as for the direction of largest curvature, which is the direction of the eigenvector of the
perturbation matrix associated to the largest eigenvalue.

\code{local_influence_plot.mixpoissonreg} provides a plot of the local influence diagnostics. Each plot corresponds to a perturbation scheme. The first plot considers
the 'case-weights' perturbation; the second plot considers the 'hidden-variable' perturbation (which was introduced in Barreto-Souza and Simas, 2016); the third plot
considers the mean-explanatory perturbation; the fourth plot considers the precision-explanatory perturbation; the fifth plot considers the simultanous-explanatory perturbation.

For both \code{local_influence.mixpoissonreg} and \code{local_influence_plot.mixpoissonreg}, one can select which covariates will be perturbed in the 'mean-explanatory',
'precision-explanatory' and 'simultaneous-explanatory' perturbation schemes. These are chosen in the 'mean.covariates' and 'precision.covariates' arguments.

If one considers the total local influence, then Zhu and Lee (2001) provides benchmark for influential observations for all perturbation schemes. These are returned as
attributes in the returned list from \code{local_influence.mixpoissonreg}. When using the \code{local_influence_plot.mixpoissonreg}, only points above the benchmark
will be displayed. One can also set the option 'draw_benchmark' to TRUE to plot the benchmark line.
}
\examples{
daysabs_progML <- mixpoissonregML(daysabs ~ prog | prog, data = Attendance)
local_influence(daysabs_progML)

}
\references{
DOI:10.1007/s11222-015-9601-6 \doi{10.1007/s11222-015-9601-6}(Barreto-Souza and Simas; 2016)

Cook, R. D. (1986) \emph{Assessment of Local Influence.} Journal of the Royal Statistical Society. Series B (Methodological), Vol. 48, pp.133-169. \href{https://rss.onlinelibrary.wiley.com/doi/10.1111/j.2517-6161.1986.tb01398.x}{https://rss.onlinelibrary.wiley.com/doi/10.1111/j.2517-6161.1986.tb01398.x}

Lesaffre, E. and Verbeke, G. (1998) \emph{Local Influence in Linear Mixed Models}. Biometrics, 54, pp. 570-582.

Poon, W.-Y. and Poon, Y.S. (1999) \emph{Conformal normal curvature and assessment of local influence.}  Journal of the Royal Statistical Society. Series B (Methodological), Vol. 61, pp.51-61. \href{https://rss.onlinelibrary.wiley.com/doi/abs/10.1111/1467-9868.00162}{https://rss.onlinelibrary.wiley.com/doi/abs/10.1111/1467-9868.00162}

Zhu, H.-T. and Lee, S.-Y. (2001) \emph{Local influence for incomplete data models.} Journal of the Royal Statistical Society. Series B (Methodological), Vol. 63, pp.111-126. \href{https://rss.onlinelibrary.wiley.com/doi/abs/10.1111/1467-9868.00279}{https://rss.onlinelibrary.wiley.com/doi/abs/10.1111/1467-9868.00279}
}
