% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_alt_optimize.R
\name{fct_alt_optimize}
\alias{fct_alt_optimize}
\title{Internal Alternating Optimization Function}
\usage{
fct_alt_optimize(
  x,
  y,
  k,
  clust_assign,
  lambda,
  alt_iter,
  anneal_iter,
  em_iter,
  temp,
  mu,
  eps,
  accept_prob,
  sim_N,
  verbose
)
}
\arguments{
\item{x}{A matrix of predictors.}

\item{y}{A matrix of responses.}

\item{k}{The number of groups.}

\item{clust_assign}{The current clustering assignment.}

\item{lambda}{A vector of penalization parameters.}

\item{alt_iter}{The maximum number of times to alternate between the classification expectation maximization algorithm and the simulated annealing algorithm.}

\item{anneal_iter}{The maximum number of simulated annealing iterations.}

\item{em_iter}{The maximum number of EM iterations.}

\item{temp}{The initial simulated annealing temperature, temp > 0.}

\item{mu}{The simulated annealing decrease temperature fraction. Once the best configuration cannot be improved, reduce the temperature to (mu)T, 0 < mu < 1.}

\item{eps}{The final simulated annealing temperature, eps > 0.}

\item{accept_prob}{The simulated annealing probability of accepting a new assignment 0 < accept_prob < 1. When closer to 1, trial assignments will only be small perturbation of the current assignment. When closer to 0, trial assignments are closer to random.}

\item{sim_N}{The simulated annealing number of iterations for reaching equilibrium.}

\item{verbose}{A boolean indicating whether to print to screen.}
}
\value{
A final fit of mixedLSR
}
\description{
Internal Alternating Optimization Function
}
\keyword{internal}
