#' Default S3 print method for decon object (derived from `deconvolve()`)
#'
#' This function sets up the default print method
#' for outputs from deconvolve function
#'
#' @param x decon object as generated by deconvolve
#' @param ... other options passed to plot
#' @return print output
#' @method print decon
#'
#' @export

print.decon <- function (x, ...) {

  cat(paste0('Deconvolution by ',
             x$n_curves,
             '-part Fraser-Suzuki mixture model fitted to \n',
             nrow(x$data), ' datapoints from ', x$temp_bounds[1],
             ' to ', x$temp_bounds[2], ' degrees C.'))

}
