% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compdist.R, R/mixdist.R, R/standist.R,
%   R/trans_standist.R
\name{r.compdist}
\alias{r.compdist}
\alias{r.mixdist}
\alias{r}
\alias{r.standist}
\alias{r.hyperdist}
\alias{r.wilcoxdist}
\alias{r.trans_univdist}
\title{Random Generation}
\usage{
\method{r}{compdist}(O, n)

\method{r}{mixdist}(O, n)

r(O, n)

\method{r}{standist}(O, n)

\method{r}{hyperdist}(O, n)

\method{r}{wilcoxdist}(O, n)

\method{r}{trans_univdist}(O, n)
}
\arguments{
\item{O}{distribution object.}

\item{n}{number of observations.}
}
\value{
Vector of computed results.
}
\description{
\code{r} is a generic function that generates random deviates of a distribution object.
}
\details{
Methods of \code{r} function generates random deviates of offered
         distribution from the package \code{\link{mistr}}. The function makes use of the r[sufix] functions
         as \code{rnorm} or \code{rbeta} and thus, if a new distribution is added,
         these functions must be reachable through the search path.

         For more complicated composite distributions, where one of the components is a mixture distribution,
         the function performs a rejection sampling of mixture random numbers to improve the speed.
}
\examples{
N <- normdist(1, 3)
r(N, 5)

C <- cauchydist()
M <- mixdist(N, C, weights = c(0.5, 0.5))
r(M, 5)

CC <- compdist(N, C, weights = c(0.5, 0.5), breakpoints = 1)
CCC <- 2*C+5
r(CCC, 5)
}
