% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_decision_curve.R
\name{plot_decision_curve}
\alias{plot_decision_curve}
\title{Plot Decision Curve (FPR vs FNR)}
\usage{
plot_decision_curve(datasim, LRmax = 1000)
}
\arguments{
\item{datasim}{A data.frame with columns \code{Related} and \code{Unrelated}
containing LR values. Can be output from \code{\link{sim_lr_genetic}},
\code{\link{sim_lr_prelim}}, \code{\link{lr_to_dataframe}}, or
\code{\link{lr_combine}}.}

\item{LRmax}{Numeric. Maximum LR value to use as threshold. Points are
generated for thresholds from 1 to LRmax. Default: 1000.}
}
\value{
A \code{ggplot2} scatter plot where:
\itemize{
\item X-axis: False Negative Rate (FNR) - proportion of true matches missed
\item Y-axis: False Positive Rate (FPR) - proportion of non-matches incorrectly identified
\item Each point represents a different LR threshold
}
The first and last threshold values are labeled on the plot.
}
\description{
Creates a scatter plot showing the trade-off between false positive rate
(FPR) and false negative rate (FNR) across different LR threshold values.
This visualization helps identify optimal decision thresholds based on
the relative costs of different types of errors.
}
\details{
If the input is a list (output from \code{\link{sim_lr_genetic}}), it is
automatically converted to a data.frame using \code{\link{lr_to_dataframe}}.

\strong{Error Rate Definitions:}
\itemize{
\item \emph{FPR}: Proportion of unrelated (H2) cases with LR > threshold
\item \emph{FNR}: Proportion of related (H1) cases with LR < threshold
}

\strong{Ideal point}: The origin (0,0) represents perfect discrimination.
Points closer to the origin indicate better thresholds.

\strong{Trade-off}: Moving along the curve, decreasing FNR typically
increases FPR and vice versa. The optimal point depends on the relative
costs of false positives vs false negatives.
}
\examples{
# Using preliminary data
lr_sims <- sim_lr_prelim("sex", numsims = 500, seed = 123)
plot_decision_curve(lr_sims)

# With lower maximum threshold for finer resolution
plot_decision_curve(lr_sims, LRmax = 100)
}
\references{
Marsico FL, Vigeland MD, Egeland T, Herrera Pinero F (2021). "Making
decisions in missing person identification cases with low statistical
power." \emph{Forensic Science International: Genetics}, 52, 102519.
\doi{10.1016/j.fsigen.2021.102519}
}
\seealso{
\code{\link{plot_lr_distribution}} for LR distribution visualization,
\code{\link{decision_threshold}} for computing optimal threshold,
\code{\link{threshold_rates}} for error rates at a specific threshold.
}
