% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lr_hair_color.R
\name{lr_hair_color}
\alias{lr_hair_color}
\title{Likelihood Ratio for Hair Color}
\usage{
lr_hair_color(
  MPc = 1,
  epc = error_matrix_hair(),
  erRc = epc,
  numsims = 1000,
  Pc = c(0.3, 0.2, 0.25, 0.15, 0.1),
  H = 1,
  Qprop = MPc,
  LR = FALSE,
  seed = 1234,
  nsims = NULL
)
}
\arguments{
\item{MPc}{Integer (1-5). Missing person's hair color category. Default: 1.}

\item{epc}{Matrix. Hair color error/confusion matrix, typically created
with \code{\link{error_matrix_hair}}. Rows represent true colors,
columns represent observed colors. Default: \code{error_matrix_hair()}.}

\item{erRc}{Matrix. Error matrix for the reference/database.
Defaults to \code{epc}.}

\item{numsims}{Integer. Number of simulations to perform. Default: 1000.}

\item{Pc}{Numeric vector of length 5. Hair color proportions in the
population. Must sum to 1. Default: c(0.3, 0.2, 0.25, 0.15, 0.1).}

\item{H}{Integer (1 or 2). Hypothesis to simulate under:
\itemize{
\item 1: H1 (Related) - Unidentified person IS the missing person
\item 2: H2 (Unrelated) - Unidentified person is NOT the missing person
}
Default: 1.}

\item{Qprop}{Integer. Query color for testing. Defaults to \code{MPc}.}

\item{LR}{Logical. If TRUE, compute and return LR values. Default: FALSE.}

\item{seed}{Integer. Random seed for reproducibility. Default: 1234.}

\item{nsims}{Deprecated. Use \code{numsims} instead.}
}
\value{
A data.frame with column \code{Col} containing simulated color
observations (1-5). If \code{LR = TRUE}, also includes column \code{LRc}
with the likelihood ratio for each observation.
}
\description{
Simulates hair color observations and optionally computes likelihood ratios
(LRs) under either H1 (unidentified person is the missing person) or H2
(unidentified person is not the missing person).

Hair color is categorized into 5 groups:
1=Black, 2=Brown, 3=Blonde, 4=Red, 5=Gray/White
}
\details{
\strong{Under H1 (Related):}
Observed color is sampled using the row of the error matrix corresponding
to the MP's true hair color. This accounts for observation errors.

\strong{Under H2 (Unrelated):}
Color is sampled from the population proportions Pc.

\strong{LR Calculation:}
LR = P(observed color | true color is MPc) / P(observed color in population)
\code{LR = epc(MPc, observed) / Pc(observed)}
}
\examples{
# Simulate under H1 (related) with black hair MP
sim_h1 <- lr_hair_color(MPc = 1, H = 1, numsims = 100)
table(sim_h1$Col)

# Simulate under H2 with LR values
sim_h2 <- lr_hair_color(MPc = 2, H = 2, numsims = 100, LR = TRUE)
head(sim_h2)
summary(sim_h2$LRc)

# Custom population proportions
sim_custom <- lr_hair_color(
  MPc = 3,  # Blonde
  Pc = c(0.1, 0.4, 0.3, 0.1, 0.1),  # Different population
  numsims = 500,
  LR = TRUE
)
}
\references{
Marsico FL, et al. (2023). "Likelihood ratios for non-genetic evidence
in missing person cases." \emph{Forensic Science International: Genetics},
66, 102891. \doi{10.1016/j.fsigen.2023.102891}
}
\seealso{
\code{\link{error_matrix_hair}} for creating the error matrix,
\code{\link{lr_pigmentation}} for combined pigmentation traits,
\code{\link{sim_lr_prelim}} for unified preliminary LR simulations.
}
