% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poly2dich.R
\name{poly2dich}
\alias{poly2dich}
\title{Change polytomous items to dichotomous item format}
\usage{
poly2dich(data, which.items = 1:ncol(data), sep = "_cat.")
}
\arguments{
\item{data}{an object of class \code{data.frame} or \code{matrix}}

\item{which.items}{a vector indicating which items should be transformed into the
dichotomous form. Default uses all input items}

\item{sep}{character vector pattern to append to each item name in \code{data}}
}
\value{
Returns an integer matrix
}
\description{
Transforms a matrix of items into a new matrix where the select polytomous items have been
converted into comparable dichotomous items with the same information.
}
\examples{

\donttest{
data(Science)

head(Science)
newScience <- poly2dich(Science)
head(newScience)

newScience2 <- poly2dich(Science, which.items = 2)
head(newScience2)

}

}
\references{
Chalmers, R., P. (2012). mirt: A Multidimensional Item Response Theory
Package for the R Environment. \emph{Journal of Statistical Software, 48}(6), 1-29.
\doi{10.18637/jss.v048.i06}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{data}
