% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/launchers.R
\name{cluster_config}
\alias{cluster_config}
\title{Cluster Remote Launch Configuration}
\usage{
cluster_config(command = "sbatch", options = "", rscript = "Rscript")
}
\arguments{
\item{command}{filename of executable e.g. "sbatch" for Slurm. Replace with
"qsub" for SGE / Torque / PBS, or "bsub" for LSF. See examples below.}

\item{options}{options as would be supplied inside a script file passed to
\code{command}, e.g. "#SBATCH --mem=16G", each separated by a new line. See
examples below.
\cr Other shell commands e.g. to change working directory may also be
included.
\cr For certain setups, "module load R" as a final line is required, or
for example "module load R/4.5.0" for a specific R version.
\cr For the avoidance of doubt, the initial shebang line such as
"#!/bin/bash" is not required.}

\item{rscript}{filename of the R executable. Use the full path of the Rscript
executable on the remote machine if necessary. If launching on Windows,
\code{"Rscript"} should be replaced with \code{"Rscript.exe"}.}
}
\value{
A list in the required format to be supplied to the \code{remote} argument
of \code{\link[=daemons]{daemons()}} or \code{\link[=launch_remote]{launch_remote()}}.
}
\description{
Generates a remote configuration for launching daemons using an HPC cluster
resource manager such as Slurm sbatch, SGE and Torque/PBS qsub or LSF bsub.
}
\examples{
# Slurm Config:
cluster_config(
  command = "sbatch",
  options = "#SBATCH --job-name=mirai
             #SBATCH --mem=16G
             #SBATCH --output=job.out
             module load R/4.5.0",
  rscript = file.path(R.home("bin"), "Rscript")
)

# SGE Config:
cluster_config(
  command = "qsub",
  options = "#$ -N mirai
             #$ -l mem_free=16G
             #$ -o job.out
             module load R/4.5.0",
  rscript = file.path(R.home("bin"), "Rscript")
)

# Torque/PBS Config:
cluster_config(
  command = "qsub",
  options = "#PBS -N mirai
             #PBS -l mem=16gb
             #PBS -o job.out
             module load R/4.5.0",
  rscript = file.path(R.home("bin"), "Rscript")
)

# LSF Config:
cluster_config(
  command = "bsub",
  options = "#BSUB -J mirai
             #BSUB -M 16000
             #BSUB -o job.out
             module load R/4.5.0",
  rscript = file.path(R.home("bin"), "Rscript")
)

\dontrun{

# Launch 2 daemons using the Slurm sbatch defaults:
daemons(n = 2, url = host_url(), remote = cluster_config())
}

}
\seealso{
\code{\link[=ssh_config]{ssh_config()}} for SSH launch configurations, or \code{\link[=remote_config]{remote_config()}}
for generic configurations.
}
