% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_cells.R
\name{validate_cells}
\alias{validate_cells}
\alias{apply_validation_method}
\alias{ask_validity_method}
\alias{ask_threshold}
\alias{ask_invalid_samples}
\alias{update_validity}
\title{Check validity of each cell in data frame.}
\usage{
validate_cells(
  raw_data,
  row_names,
  col_names,
  validity_method = c("threshold", "samples"),
  threshold = NULL,
  invalid_samples = NULL
)

apply_validation_method(
  value,
  i,
  j,
  row_names,
  col_names,
  validity_method = c("threshold", "samples"),
  threshold = NULL,
  invalid_samples = NULL
)

ask_validity_method()

ask_threshold()

ask_invalid_samples()

update_validity(
  input_data,
  wp_var = "Position",
  well_positions,
  group_levels = NULL
)
}
\arguments{
\item{raw_data}{The original data frame.}

\item{row_names}{Names or identifiers of rows in the matrix or data frame.}

\item{col_names}{Names or identifiers of columns in the matrix or data frame.}

\item{validity_method}{The method used to determine validity. Either 'threshold' or 'samples'.}

\item{threshold}{A threshold value used for determining validity. Only applied if 'validity_method
is set to 'threshold'.}

\item{invalid_samples}{A container for storing invalid samples or their indices. Only applied if 'validity_method
is set to 'samples'.}

\item{value}{The value to be checked for validity.}

\item{i}{The row index of the value in the matrix or data frame.}

\item{j}{The column index of the value in the matrix or data frame.}

\item{input_data}{A dataframe containing the data to be updated.}

\item{wp_var}{A character string specifying the column providing the well positions. Defaults to
"Position".}

\item{well_positions}{The well positions to filter the data on.}

\item{group_levels}{A list specifying the combinations of factors A, B, and C to match.
Each element of the list should be a vector of factor levels.}
}
\value{
\code{validate_cells} returns a data frame with validity information

\code{apply_validation_method} returns logical value indicating whether the value meets the validity criteria.

The user's validity method preference

\code{ask_threshold} returns the user-specified threshold

\code{ask_invalid_samples} returns a vector of invalid samples

\code{update_validity} returns the updated dataframe with Validity modified accordingly.
}
\description{
\code{validate_cells} checks if samples are valid based on either a user-set threshold (i.e.
a maximum absorption value) or a list of invalid samples provided by the user.

\code{apply_validation_method} evaluates whether a sample meets a user-set validity criteria based 
on a specified validity method.

\code{ask_validity_method} applies a user prompt to check for the validation method to apply
on the samples. This can be either 'threshold' (then a maximum absorption value is asked via a call to function
\code{ask_threshold}) or 'samples'

\code{ask_threshold} applies a user prompt to check for a valid absorption maximum used as a threshold.

\code{ask_invalid_samples} applies a user prompt to check for invalid samples.

\code{update_validity} updates the Validity column in a dataframe based on a specified position
and combinations of factors. It sets the Validity to "invalid" for rows where the Position
matches the specified position and where the combinations of factors A, B, and C match the
provided group levels.
}
\examples{
df <- data.frame(Position = c("pos1", "pos2", "pos2", "pos4", "pos4"),
                 Value = c(1, 2, 3, 4, 5),
                 Validity = c("valid", "valid", "valid", "valid", "valid"),
                 A = c("a1", "a2", "a3", "a1", "a2"),
                 B = c("b1", "b2", "b3", "b1", "b2"),
                 C = c("c1", "c2", "c3", "c1", "c2"))
updated_df <- update_validity(df,
                              well_positions = "pos2",
                              group_levels = list(A = c("a2", "a3"), B = c("b2", "b3")))
updated_df
}
\seealso{
\code{\link{generate_experiment_list}}, \code{\link{ask_experiment_list}},
\code{\link{generate_group_list}}, \code{\link{ask_group_list}},
\code{\link{add_treatment}}, \code{\link{add_concentration}}, \code{\link{validate_cells}}
}
