% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_plates_via_prompts.R
\name{tidy_plates_via_prompts}
\alias{tidy_plates_via_prompts}
\title{Read raw photometry data and add meta data based on user input}
\usage{
tidy_plates_via_prompts(
  input_data,
  direction = c("horizontal", "vertical"),
  ...
)
}
\arguments{
\item{input_data}{The folder path to the files containing the raw photometer data. Data files should 
be given as plain text files and with timepoint identifiers in their file names (e.g. "file_T0.txt" or 
"file_t0.txt").}

\item{direction}{A character vector specifying the orientation of the plate layout.
It can be either "horizontal" or "vertical".}

\item{...}{Additional arguments to be passed to \code{\link{read_plates}}.}
}
\value{
A tidy data frame containing absorption values and meta data (validity of samples as well as 
treatment and concentration level information).
}
\description{
Most old photometer devices save the data in plain text files. If there was ever analysis software, 
this is often no longer available due to increasing technical requirements or proprietary software 
should generally be avoided. Especially for broth microdilution assays, it is necessary to measure 
the photometer plates at several points in time, which means that the same samples are represented 
in several files with their corresponding values. Usually the data is then merged manually, which can 
lead to mistakes and takes up unnecessary time. In this case, the `tidy_plates()` function provides a convenient 
way to read in the raw files and, based on user input, add metadata on the validity of the samples, 
as well as treatment groups and concentration levels.
}
\seealso{
\code{\link{tidy_single_plate}}, \code{\link{tidy_plates_via_params}}
}
