% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_concentration.R
\name{add_concentration}
\alias{add_concentration}
\alias{generate_concentration_list}
\alias{ask_concentration_list}
\alias{match_concentration}
\title{Add concentration metadata}
\usage{
add_concentration(
  input_data,
  concentration_list = NULL,
  ask_concentration_list = TRUE,
  ...
)

generate_concentration_list(concentration_levels, direction)

ask_concentration_list(direction = c("horizontal", "vertical"))

match_concentration(well_position, concentration_list)
}
\arguments{
\item{input_data}{A data frame with well positions and their corresponding values.}

\item{concentration_list}{A list containing concentration information}

\item{ask_concentration_list}{A boolean parameter indicating whether concentration levels should be retrieved via user prompt (default) or not.}

\item{...}{Additional arguments to be passed to \code{\link{ask_concentration_list}}.}

\item{concentration_levels}{A numeric vector containing concentration levels.}

\item{direction}{A character vector specifying the orientation of the plate layout. 
It can be either "horizontal" or "vertical".}

\item{well_position}{The sample position(s) to check}
}
\value{
\code{add_concentration} returns a data frame with concentration metadata added.

\code{generate_concentration_list} returns a list of concentration levels where each level is assigned to a corresponding 
        row or column based on the selected direction parameter.

\code{ask_concentration_list} returns a list containing plate axes as keys and concentration information as values.

\code{match_concentration} returns the corresponding concentration level if sample position matches concentration criteria, "NA" otherwise
}
\description{
\code{add_concentration} adds concentration metadata to photometer data that is specified in long format.
For this function to work properly, the column containing the well positions should be named 'Position'
and the column containing the corresponding absorption values should be named 'Values'.

\code{generate_concentration_list} generates a list of provided concentration levels mapped to the user-specified
plate layout. The plate layout is based on a 96-well plate and can be either horizontal (i.e. letters A-H) or vertical (i.e. numbers 1-12).

\code{ask_concentration_list} works the same way as \code{generate_concentration_list}, but retrieves the
concentration levels based on a user prompt instead of user-set parameters. The plate axis can be either in horizontal direction
providing letters A-H or in vertical direction providing numbers 1-12 based on a 96-well plate layout.

\code{match_concentration} maps concentration levels to corresponding well positions and returns 'NA' otherwise.
}
\details{
\code{generate_concentration_list} checks if the length of \code{concentration_levels} matches the specified 
number of rows or columns based on the direction parameter. If not, it throws an error.
If the lengths match, it generates a list of concentration levels where each level is 
assigned to a corresponding row or column based on the direction parameter.
}
\seealso{
\code{\link{generate_experiment_list}}, \code{\link{ask_experiment_list}},
\code{\link{generate_group_list}}, \code{\link{ask_group_list}},
\code{\link{add_treatment}}, \code{\link{validate_cells}}
}
