% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_glm.R
\name{pool_glm}
\alias{pool_glm}
\title{Pools and selects Linear and Logistic regression models across multiply imputed data.}
\usage{
pool_glm(
  object,
  method = "D1",
  p.crit = 1,
  keep.predictors = NULL,
  direction = NULL
)
}
\arguments{
\item{object}{An object of class 'mistats' ('Multiply Imputed
Statistical Analyses').}

\item{method}{A character vector to indicate the multiparameter pooling method to pool
the total model or used during model selection. This can be "RR", D1", "D2", "D3",
"D4", or "MPR". See details for more information. Default is "RR".}

\item{p.crit}{A numerical scalar. P-value selection criterium. A value of 1
provides the pooled model without selection.}

\item{keep.predictors}{A single string or a vector of strings including the variables that are forced
in the model during model selection. All type of variables are allowed.}

\item{direction}{The direction for model selection, "BW" means backward selection and "FW"
means forward selection.}
}
\value{
An object of class \code{mipool} (multiply imputed pooled models) from
which the following objects can be extracted:
\itemize{
\item  \code{pmodel} pooled model (at last selection step)
\item  \code{pmultiparm} pooled p-values according to multiparameter test method
(at last selection step)
\item  \code{pmodel_step} pooled model (at each selection step)
\item  \code{pmultiparm_step} pooled p-values according to multiparameter test method
(at each selection step)
\item  \code{multiparm_final} pooled p-values at final step according to pooling method
\item  \code{multiparm_out} (only when direction = "FW") pooled p-values of removed predictors
\item  \code{formula_final} formula object at final step
\item  \code{formula_initial} formula object at final step
\item  \code{predictors_in} predictors included at each selection step
\item  \code{predictors_out} predictors excluded at each step
\item  \code{impvar} name of variable used to distinguish imputed datasets
\item  \code{nimp} number of imputed datasets
\item  \code{Outcome} name of the outcome variable
\item  \code{method} selection method
\item  \code{p.crit} p-value selection criterium
\item  \code{call} function call
\item  \code{model_type} type of regression model used
\item  \code{direction} direction of predictor selection
\item  \code{predictors_final} names of predictors in final selection step
\item  \code{predictors_initial} names of predictors in start model
\item  \code{keep.predictors} names of predictors that were forced in the model
}
}
\description{
\code{pool_glm} Pools and selects Linear and Logistic regression models across multiply
imputed data, using pooling methods RR, D1, D2, D3, D4 and MPR (in combination with
'with' function).
}
\details{
The basic pooling procedure to derive pooled coefficients, standard errors, 95
confidence intervals and p-values is Rubin's Rules (RR). However, RR is only possible when
the model includes continuous and dichotomous variables. Multiparameter pooling methods are
available when the model also included categorical (> 2 categories) variables.
These pooling methods are: “D1” is pooling of the total covariance matrix,
”D2” is pooling of Chi-square values, “D3” and "D4" is pooling Likelihood ratio statistics
(method of Meng and Rubin) and “MPR” is pooling of median p-values (MPR rule).
For pooling restricted cubic splines using the 'rcs' function of of the rms package,
use function 'glm_mi'.

A typical formula object has the form \code{Outcome ~ terms}. Categorical variables has to
be defined as \code{Outcome ~ factor(variable)}. Interaction terms can be defined as
\code{Outcome ~ variable1*variable2} or \code{Outcome ~ variable1 + variable2 + variable1:variable2}.
All variables in the terms part have to be separated by a "+".
}
\section{Vignettes}{

https://mwheymans.github.io/miceafter/articles/regression_modelling.html
}

\examples{

  dat_list <- df2milist(lbpmilr, impvar="Impnr")
  ra <- with(data=dat_list, expr = glm(Chronic ~ factor(Carrying) + Radiation + Age))
  poolm <- pool_glm(ra, method="D1")
  poolm$pmodel
  poolm$pmultiparm

}
\references{
Eekhout I, van de Wiel MA, Heymans MW. Methods for significance testing of categorical
covariates in logistic regression models after multiple imputation: power and applicability
analysis. BMC Med Res Methodol. 2017;17(1):129.

Enders CK (2010). Applied missing data analysis. New York: The Guilford Press.

Meng X-L, Rubin DB. Performing likelihood ratio tests with multiply-imputed data sets.
Biometrika.1992;79:103-11.

van de Wiel MA, Berkhof J, van Wieringen WN. Testing the prediction error difference between
2 predictors. Biostatistics. 2009;10:550-60.

Marshall A, Altman DG, Holder RL, Royston P. Combining estimates of interest in prognostic
modelling studies after multiple imputation: current practice and guidelines. BMC Med Res Methodol.
2009;9:57.

Van Buuren S. (2018). Flexible Imputation of Missing Data. 2nd Edition. Chapman & Hall/CRC
Interdisciplinary Statistics. Boca Raton.
}
\author{
Martijn Heymans, 2021
}
