% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VIF.R
\name{VIF}
\alias{VIF}
\alias{VIF.data.frame}
\alias{VIF.data.table}
\alias{VIF.matrix}
\title{\code{VIF} function for assessing VIF.}
\usage{
VIF(x, posit_y, posit_x, correct = FALSE)

\method{VIF}{data.frame}(x, posit_y, posit_x, correct = FALSE)

\method{VIF}{data.table}(x, posit_y, posit_x, correct = FALSE)

\method{VIF}{matrix}(x, posit_y, posit_x, correct = FALSE)
}
\arguments{
\item{x}{a numeric matrix or data.frame/data.table (factor/character/numeric) - variables}

\item{posit_y}{an integer/character - a position/name of dependent variable.
This variable is taken into account only for getting complete cases.}

\item{posit_x}{an integer/character vector - positions/names of independent variables}

\item{correct}{a boolean - basic or corrected - Default: FALSE}
}
\value{
load a numeric vector with VIF for all variables provided by posit_x
}
\description{
VIF measure how much the variance of the estimated regression coefficients are inflated.
It helps to identify when the predictor variables are linearly related.
You have to decide which variable should be delete.
Usually values higher than 10 (around), mean a collinearity problem.
}
\section{Methods (by class)}{
\itemize{
\item \code{VIF(data.frame)}: 

\item \code{VIF(data.table)}: 

\item \code{VIF(matrix)}: 

}}
\note{
The corrected VIF is obtained by raising the basic VIF to the power of one divided by two times the degrees of freedom.
}
\examples{
\dontrun{
library(miceFast)
library(data.table)

airquality2 <- airquality
airquality2$Temp2 <- airquality2$Temp**2
airquality2$Month <- factor(airquality2$Month)
data_DT <- data.table(airquality2)
data_DT[, .(vifs = VIF(
  x = .SD,
  posit_y = "Ozone",
  posit_x = c("Solar.R", "Wind", "Temp", "Month", "Day", "Temp2"),
  correct = FALSE
))][["vifs.V1"]]

data_DT[, .(vifs = VIF(
  x = .SD,
  posit_y = 1,
  posit_x = c(2, 3, 4, 5, 6, 7),
  correct = TRUE
))][["vifs.V1"]]
}

}
\seealso{
\code{\link{fill_NA}} \code{\link{fill_NA_N}}
}
