% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_evt.R
\name{calc_lamb}
\alias{calc_lamb}
\title{Lamb vector (sometimes called vortex energy)}
\usage{
calc_lamb(
  u_fld,
  v_fld,
  w_fld,
  lev_p,
  lat = NULL,
  dx = 0.25,
  dy = 0.25,
  relative = TRUE,
  zvort_fld = NULL,
  mode = "lonlat"
)
}
\arguments{
\item{u_fld}{zonal velocity field [m/s]}

\item{v_fld}{meridional velocity field [m/s]}

\item{w_fld}{vertical velocity field [m/s]}

\item{lev_p}{vector containing pressure levels [Pa]}

\item{lat}{vector containing latitude}

\item{dx}{x resolution in the corresponding unit (e.g. 0.25 degree for ERA5 with \code{mode='lonlat'} or e.g. 1000 m in cartesian coordinates with \code{mode='cartesian'})}

\item{dy}{y resolution in the corresponding unit (e.g. 0.25 degree for ERA5 with \code{mode='lonlat'} or e.g. 1000 m in cartesian coordinates with \code{mode='cartesian'})}

\item{relative}{logical, TRUE: only relative vorticity, FALSE: whole (absolute) vorticity should be used for calculation of enstrophy, default: TRUE}

\item{zvort_fld}{optional zvort field (if e.g., zvort is directly taken from ERA5 and not calculated separately)}

\item{mode}{use 'lonlat' if the data is given on a lon-lat-grid or 'cartesian' if the data is given on an equidistant cartesian grid}
}
\value{
lamb vector [m/s^2]
}
\description{
Calculates the Lamb vector (cross product of wind vector and vorticity vector)
}
\examples{
myfile=system.file("extdata", "era5_storm-zeynep.nc", package = "meteoEVT")
data = readin_era5(myfile)
lamb=calc_lamb(data$u,data$v,data$w,data$lev,lat=data$lat)
}
