% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaprotr_plot_pietaxo.R
\name{plot_pietaxo}
\alias{plot_pietaxo}
\title{plot_pietaxo}
\usage{
plot_pietaxo(
  spectral_count_object,
  target_variable,
  sampling,
  filter_percent = 1,
  force = FALSE
)
}
\arguments{
\item{spectral_count_object}{list defined as "spectral_count_object" 
containing dataframes with spectral counts abundance of the 
samples organized by taxonomy (species, genus, family, 
order, class, phylum or superkingdom). This object is generated 
with the function "crumble_taxonomy".}

\item{target_variable}{Character indicating the name of one column 
from metadata. This column must contain the identifiers of the sample 
or condition to be plotted.}

\item{sampling}{Character indicating the name of sample or condition
to be plotted. This character must be present in the "target_variable".}

\item{filter_percent}{Optional numeric value between 0 and 99 that 
sets the minimal percentage of spectral counts at which the taxonomic 
elements will be displayed. The elements whose values are lower than 
this number will be gathered and displayed as "others". 
The default value is set at 1.}

\item{force}{Logic value set at FALSE by default in order to ask 
permission to create files in the workstation of the user.}
}
\value{
A pie chart (pdf) and a csv file with the taxonomic 
   distribution of one sample or one condition. In the csv file, 
   all the elements have their: a) spectral counts, b) percentage of 
   spectral count in the sample, c) the taxonomic name and d)
   the taxonomic elements that were assiged as 'others' in function 
   of the filter provided.
}
\description{
Generates a pie chart with taxonomic distribution of one selected
sample or condition. If the provided condition has several replicates 
the mean value is taken into account.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}

data(species_fw)

plot_pietaxo(species_fw, "Methods", "S")

plot_pietaxo(species_fw, "SC_name", "Q1")

\dontshow{setwd(.old_wd)}
}
