% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaprotr_plot_dendocluster.R
\name{plot_dendocluster}
\alias{plot_dendocluster}
\title{plot_dendocluster}
\usage{
plot_dendocluster(
  spectral_count_object,
  target_variable,
  file_title,
  hclust_method = "ward.D",
  correlation_method = "spearman",
  force = FALSE
)
}
\arguments{
\item{spectral_count_object}{List defined as "spectral_count_object" 
containing dataframes with abundance expressed as spectral counts 
from peptides, subgroups, groups or taxonomic levels. The format 
of this object is similar to that generated from the functions
"getsc_specific" and "crumble_taxonomy".}

\item{target_variable}{Character indicating the name of one column 
from metadata. The different levels in this column will be represented 
as different colors in the final dendogram.}

\item{file_title}{Character indicating the name of the generated file.}

\item{hclust_method}{Character indicating the agglomeration method to be 
used for the hierarchical clustering. The possible methods are discribed 
on \href{https://www.rdocumentation.org/packages/stats/versions/3.6.2/topics/hclust}{hclust}.
The default method is "ward.D".}

\item{correlation_method}{Character indicating the correlation coeficient to 
be computed. The possible options are discribed in the function 
\href{https://www.rdocumentation.org/packages/stats/versions/3.6.2/topics/cor}{cor}. 
The default value is "spearman".}

\item{force}{Logic value set at FALSE by default in order to ask 
permission to create a pdf file in the workstation of the user.}
}
\value{
A dendogram plot (pdf) indicating the number of elements per
   sample.
}
\description{
Draws a dendogram where samples are clustered based on the number of elements 
present on each sample from a "spectral_count_object". This graph is 
constructed based on Spearman correlations transformed into distances 
and plotted with the logic of the package 
\href{https://CRAN.R-project.org/package=dendextend}{dendextend}.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}

data(fecal_waters)
str(fecal_waters$metadata)

plot_dendocluster(fecal_waters, "Condition", "title_dendogram")

plot_dendocluster(fecal_waters, "Condition", "title_dendogram", 
   hclust_method = "mcquitty")

plot_dendocluster(fecal_waters, "Condition", "title_dendogram_groups", 
   correlation_method = "pearson")

\dontshow{setwd(.old_wd)}
}
