% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plaisted_peterson.R
\name{plaisted_peterson}
\alias{plaisted_peterson}
\title{Stability analysis based on Plaisted and Peterson (1959)}
\usage{
plaisted_peterson(.data, env, gen, rep, resp, verbose = TRUE)
}
\arguments{
\item{.data}{The dataset containing the columns related to Environments,
Genotypes, replication/block and response variable(s).}

\item{env}{The name of the column that contains the levels of the
environments.}

\item{gen}{The name of the column that contains the levels of the genotypes.}

\item{rep}{The name of the column that contains the levels of the
replications/blocks.}

\item{resp}{The response variable(s). To analyze multiple variables in a
single procedure use, for example, \code{resp = c(var1, var2, var3)}.}

\item{verbose}{Logical argument. If \code{verbose = FALSE} the code will run
silently.}
}
\value{
An object of class \code{plaisted_peterson} containing the results for each
variable used in the argument \code{resp}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The function computes the stability as the arithmetic mean of the variance
component of the genotype-environment interaction between environment pairs
that includes a given genotype
}
\examples{
\donttest{
library(metan)
 plaisted_peterson(data_ge, ENV, GEN, REP, GY)
}

}
\references{
Plaisted, R.L., and L.C. Peterson. 1959. A technique for
evaluating the ability of selections to yield consistently in different
locations or seasons. American Potato Journal 36(11): 381–385.
\doi{10.1007/BF02852735}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
