% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{calc_nominal_km}
\alias{calc_nominal_km}
\title{Calculate the nominal Kendrick mass}
\usage{
calc_nominal_km(mass, repeating_unit = "CH2")
}
\arguments{
\item{mass}{A molecular mass (or m/z).}

\item{repeating_unit}{The formula of the repeating unit, given as a string.}
}
\value{
The nominal Kendrick mass.
}
\description{
The nominal Kendrick mass is the Kendrick mass
(\code{\link[metamorphr]{calc_km}}), rounded up to the nearest
whole number. The nominal Kendrick mass and the Kendrick mass are both required
to calculate the Kendrick mass defect (KMD).
The nominal Kendrick mass is not to be confused with the Kendrick mass defect
(\code{\link[metamorphr]{calc_kmd}}) and
the Kendrick mass (\code{\link[metamorphr]{calc_km}}).
}
\examples{
# Calculate the nominal Kendrick masses for two measured masses with
# CH2 as the repeating unit.
# See Hughey et al. in the References section above

calc_nominal_km(c(351.3269, 365.3425))

# Construct a KMD plot from m/z values.
# RT is mapped to color and the feature-wise maximum intensity to size.

toy_metaboscape \%>\%
  dplyr::group_by(UID, `m/z`, RT) \%>\%
  dplyr::summarise(max_int = max(Intensity, na.rm = TRUE)) \%>\%
  dplyr::ungroup() \%>\%
  dplyr::mutate(KMD = calc_kmd(`m/z`),
                `nominal KM` = calc_nominal_km(`m/z`)) \%>\%
  ggplot2::ggplot(ggplot2::aes(x = `nominal KM`,
                               y = KMD,
                               size = max_int,
                               color = RT)) +
    ggplot2::geom_point()
}
\references{
\itemize{
\item \href{https://en.wikipedia.org/wiki/Kendrick_mass}{Kendrick mass on Wikipedia}
\item Edward Kendrick, \emph{Anal. Chem.} \strong{1963}, \emph{35}, 2146–2154.
\item C. A. Hughey, C. L. Hendrickson, R. P. Rodgers, A. G. Marshall, K. Qian, \emph{Anal. Chem.} \strong{2001}, \emph{73}, 4676–4681.
}
}
