% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{delayed_with}
\alias{delayed_with}
\title{Apply expressions to data.frames}
\usage{
delayed_with(...)
}
\arguments{
\item{...}{Expressions that will be evaluated.}
}
\value{
A function that takes a \code{data.frame} and returns the expressions in \code{...}
evaluated in an environment constructed from it.
}
\description{
Creates a function that evaluates expressions in a future data.frame. Is like
\code{with()}, but the data argument is passed at a later step.
}
\details{
Each expression in \code{...} must return a single numeric value. They can be named or
return named vectors.
}
\examples{
some_stats <- delayed_with(mean_x = mean(x), mean(y), sd(x), coef(lm(x ~ y)))
data <- data.frame(x = rnorm(20) , y = rnorm(20))
some_stats(data)

}
\seealso{
Other helper functions: 
\code{\link{densify}()},
\code{\link{draw_data}()},
\code{\link{mean_dist_to_sf}()},
\code{\link{mean_dist_to}()},
\code{\link{mean_self_proximity}()},
\code{\link{moments_n}()},
\code{\link{truncate_to}()}
}
\concept{helper functions}
