% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimaandpaths.R
\name{oneminimum.fes3d}
\alias{oneminimum.fes3d}
\title{Creates one ad hoc 3D free energy minimum for a fes object}
\usage{
\method{oneminimum}{fes3d}(inputfes, cv1, cv2, cv3)
}
\arguments{
\item{inputfes}{fes3d object.}

\item{cv1}{the value of collective variable 1.}

\item{cv2}{the value of collective variable 2.}

\item{cv3}{the value of collective variable 3.}
}
\value{
minima object.
}
\description{
`oneminimum.fes3d` creates an ad hoc 3D free energy minimum on free energy surface.
This can be used to calculate 3D free energy surface evolution at arbitrary
point of free energy surface.
}
\examples{
tfes<-fes(acealanme3d, imax=1000)
minima<-fesminima(tfes)
minima<-minima+oneminimum(tfes, cv1=0, cv2=0, cv3=0)
minima
}
