% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_ANCOVA_MD.R
\name{es_from_ancova_md_se}
\alias{es_from_ancova_md_se}
\title{Convert an adjusted mean difference and standard error between two independent groups obtained from an ANCOVA model into several effect size measures}
\usage{
es_from_ancova_md_se(
  ancova_md,
  ancova_md_se,
  cov_outcome_r,
  n_cov_ancova,
  n_exp,
  n_nexp,
  smd_to_cor = "viechtbauer",
  reverse_ancova_md
)
}
\arguments{
\item{ancova_md}{adjusted mean difference between two independent groups}

\item{ancova_md_se}{covariate-adjusted standard error of the mean difference}

\item{cov_outcome_r}{correlation between the outcome and covariate (multiple correlation when multiple covariates are included in the ANCOVA model).}

\item{n_cov_ancova}{number of covariates in the ANCOVA model.}

\item{n_exp}{number of participants in the experimental/exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{smd_to_cor}{formula used to convert the \code{cohen_d} value into a coefficient correlation (see details).}

\item{reverse_ancova_md}{a logical value indicating whether the direction of generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab MD + D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z \cr
\tab \cr
\code{required input data} \tab See 'Section 20. Adjusted: Mean difference and dispersion'\cr
\tab https://metaconvert.org/input.html\cr
\tab \cr
}
}
\description{
Convert an adjusted mean difference and standard error between two independent groups obtained from an ANCOVA model into several effect size measures
}
\details{
This function converts the mean difference (MD) standard error into a standard deviation,
and then relies on the calculations of the \code{\link{es_from_ancova_md_sd}} function.

\strong{To convert the standard error into a standard deviation}, the following formula is used.
\deqn{ancova\_md\_sd = \frac{ancova\_md\_se}{\sqrt{1 / n_exp + 1 / n_nexp}}}
Calculations of the \code{\link{es_from_ancova_md_sd}()} are then applied.
}
\examples{
es_from_ancova_md_se(
  ancova_md = 4, ancova_md_se = 2,
  cov_outcome_r = 0.5, n_cov_ancova = 5,
  n_exp = 20, n_nexp = 22
)
}
