% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state_match.R
\name{state_match}
\alias{state_match}
\title{state_match}
\usage{
state_match(messy_states, threshold = NA, p = 0)
}
\arguments{
\item{messy_states}{Vector containing the messy state names that will be replaced
by the closest match from \code{state.name}}

\item{threshold}{The maximum distance that will form a match. If this argument
is specified, any element in the messy vector that has no match closer than
the threshold distance will be replaced with NA. Default: NA}

\item{p}{Only used with method "jw", the Jaro-Winkler penatly size. Default: 0}
}
\value{
\code{state_match()} returns a cleaned version of the bad vector, with each
element replaced by the most similar element of the good vector.
}
\description{
A wrapper function for \code{cat_match()}hat only requires an inputted
vector of messy states. \code{state_match()} uses a built in clean list of
state names \code{state.name} as the reference clean vector.
}
\details{
State names are often misspelled or abbreviated in datasets, especially datasets that have been
manually digitized or created. \code{state_match()} is a warpper function of \code{cat_match()} that quickly solves
this common issue of mispellings or different formats of country names across datasets. This wrapper
function uses a built in clean list of country names \code{state.name} as the reference clean vector and
matches your inputted messy vector of names to their nearest state in \code{state.name}.
}
\examples{
if(interactive()){
 #EXAMPLE1
 lst <- c("Indianaa", "Wisvconsin", "aLaska", "NewJersey", "Claifoarni")
 matched <- state_match(lst)
 }
}
