% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_data.R
\name{raw_data}
\alias{raw_data}
\title{Get paths to \code{mctq} raw datasets}
\usage{
raw_data(file = NULL)
}
\arguments{
\item{file}{(optional) a \code{\link[=character]{character}} object indicating the raw
data file name(s). If \code{NULL}, all raw data file names will be returned
(default: \code{NULL}).}
}
\value{
If \code{file == NULL}, a \code{\link[=character]{character}} object with all file
names available. Else, a string with the file name path.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

\code{mctq} comes bundled with raw fictional datasets for testing and learning
purposes. \code{raw_data()} makes it easy to access their paths.
}
\examples{
\dontrun{
## To list all raw data file names available

raw_data()

## To get the file path from a specific raw data

raw_data("std_mctq.csv")}
}
\seealso{
Other utility functions: 
\code{\link{pretty_mctq}()},
\code{\link{random_mctq}()}
}
\concept{utility functions}
