% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MclustBounded.R
\name{predict.MclustBounded}
\alias{predict.MclustBounded}
\title{Model-based clustering estimation for bounded data}
\usage{
\method{predict}{MclustBounded}(object, newdata, ...)
}
\arguments{
\item{object}{An object of class \code{'MclustBounded'} resulting
from a call to \code{\link[=MclustBounded]{MclustBounded()}}.}

\item{newdata}{A numeric vector, matrix, or data frame of observations. If
missing the density is computed for the input data obtained from the call to
\code{\link[=MclustBounded]{MclustBounded()}}.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
Returns a list of with the following components:
\itemize{
\item \code{classification} A factor of predicted cluster labels for newdata.
\item \code{z} A matrix whose \eqn{[i,k]}th entry is the probability that \eqn{i}th
observation in \code{newdata} belongs to the \eqn{k}th cluster.
}
}
\description{
Predict clustering for univariate and multivariate bounded data based on
Gaussian finite mixture models estimated by \code{\link[=MclustBounded]{MclustBounded()}}.
}
\references{
Scrucca L. (2019) A transformation-based approach to Gaussian
mixture density estimation for bounded data. \emph{Biometrical Journal},
61:4, 873–888. \doi{doi:10.1002/bimj.201800174}
}
\seealso{
\code{\link[=MclustBounded]{MclustBounded()}}, \code{\link[=plot.MclustBounded]{plot.MclustBounded()}}.
}
\author{
Luca Scrucca
}
