% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/re.R
\name{perl_flavor}
\alias{perl_flavor}
\alias{perl_flavor<-}
\title{Retrieve or set the flavor of a regular expression}
\usage{
perl_flavor(x)

perl_flavor(x) <- value
}
\arguments{
\item{x}{Object of class \code{\link{re}}.}

\item{value}{Logical.}
}
\value{
A logical vector of length 1.
}
\description{
These functions retrieve or set the \code{perl} property of an object of class \code{\link{re}}.
}
\details{
The assignment function merely sets the \code{perl} property so that the \code{x}
attribute is read as an expression using the PCRE flavor of regular expression
(when \code{perl = TRUE}) or not (when \code{perl = FALSE}).
The regular expression itself is not modified: if \code{perl} is set to an
inappropriate value, the regular expression will no longer function properly in
any of the functions that support \code{\link{re}} objects.
}
\examples{
(regex <- re("^.{3,}"))
perl_flavor(regex)

perl_flavor(regex) <- FALSE
perl_flavor(regex)
regex

perl_flavor(regex) <- TRUE
perl_flavor(regex)
regex
}
