% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/assoc.R, R/conc.R, R/fnames.R,
%   R/freqlist.R, R/tokenize.R, R/types.R
\name{explore}
\alias{explore}
\alias{explore.assoc_scores}
\alias{explore.conc}
\alias{explore.fnames}
\alias{explore.freqlist}
\alias{explore.tokens}
\alias{explore.types}
\title{Interactively navigate through an object}
\usage{
explore(x, ...)

\method{explore}{assoc_scores}(
  x,
  n = 20,
  from = 1,
  from_col = 1,
  perl = TRUE,
  sort_order = c("none", "G_signed", "PMI", "alpha"),
  use_clear = TRUE,
  ...
)

\method{explore}{conc}(x, n = 20, from = 1, use_clear = TRUE, ...)

\method{explore}{fnames}(x, n = 20, from = 1, perl = TRUE, use_clear = TRUE, ...)

\method{explore}{freqlist}(x, n = 20, from = 1, perl = TRUE, use_clear = TRUE, ...)

\method{explore}{tokens}(x, n = 20, from = 1, perl = TRUE, use_clear = TRUE, ...)

\method{explore}{types}(x, n = 20, from = 1, perl = TRUE, use_clear = TRUE, ...)
}
\arguments{
\item{x}{An object of any of the classes for which the method is implemented.}

\item{...}{Additional arguments.}

\item{n}{Maximum number of items in the object to be printed at once.}

\item{from}{Index of the first item to be printed.}

\item{from_col}{Index of the first column to be displayed in the regular area
(among all selected columns, including frozen columns). If \code{from_col} points}

\item{perl}{Logical. Whether or not the regular expressions used in the
exploration session use the PERL flavor of regular expression.}

\item{sort_order}{Order in which the items are to be printed. In general, possible values
are \code{"alpha"} (meaning that the items are to be sorted alphabetically),
and \code{"none"} (meaning that the items are not to be sorted).
If \code{x} is an object of class \code{\link{assoc_scores}}, a column name
or vector of column names may be provided instead.}

\item{use_clear}{Logical. If \code{TRUE}, and if the feature is supported by the R
environment, the console will be cleared in between all interactive steps
in the exploration session.}
}
\value{
Invisibly, \code{x}.
}
\description{
This method only works in an interactive R session to open
'exploration mode', in which the user can navigate through the
object \code{x} by means of brief commands.
}
\details{
\code{explore()} is different from other R instructions because it does not
automatically stop executing and show a new regular prompt (\code{>}) in the console.
Instead it shows a special prompt (\verb{>>}) at which you can use \code{explore()}-specific
commands. Note that at the special prompt \verb{>>} none of the regular R instructions
will work. The instructions that do work at this prompt, for \code{explore()}, are
listed below. After each instruction the user must press \code{ENTER}.
\itemize{
\item \code{b} (begin): The first items in \code{x} are shown.
\item \code{e} (end): The last items in \code{x} are shown.
\item \code{d} (down \emph{n} items): The 'next page' of items is shown.
\item \code{u} (up \emph{n} items): The 'previous page' of items is shown.
\item \code{n} (next item): The list/table shifts one item down the list.
\item \code{p} (previous item): The list/table shifts one item up the list.
\item \verb{g \{linenumber\}} (go to...): Jump to line \code{{linenumber}}.

E.g. \verb{g 1000} will jump to the 1000th line.
\item \verb{f \{regex\}} (find...): Jump to the next item matching the regular expression \code{{regex}}.

E.g. \verb{f (?xi) astic $} will jump to the next item ending in \code{"astic"}.
The software starts searching from the \emph{second item} presently visible onward.

\code{f} will jump to the next item matching the last regular expression used with
\verb{f \{regex\}}.

This command is \strong{not} available when \code{x} is a \code{\link{conc}} object.
\item \code{l} (left): In \code{\link{assoc_scores}} objects, move one column to the left.
\item \code{r} (right): In \code{\link{assoc_scores}} objects, move one column to the right.
\item \verb{?}: A help page is displayed, showing all possible commands.
\item \code{q} (quit): Terminate interactive session.
}
}
