% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ca.R
\name{ca_help}
\alias{ca_help}
\alias{row_pcoord}
\alias{col_pcoord}
\alias{xlim4ca}
\alias{ylim4ca}
\title{Helpers for plotting \code{ca} objects}
\usage{
row_pcoord(x, ...)

col_pcoord(x, ...)

xlim4ca(x, ...)

ylim4ca(x, ...)
}
\arguments{
\item{x}{An object of class \code{\link[ca:ca]{ca}}.}

\item{...}{Additional arguments (not implemented).}
}
\value{
A matrix (for \code{row_pcoord()} and \code{col_pcoord()}) or a numeric vector
(for \code{xlim4ca()} and \code{ylim4ca()}).
}
\description{
The functions \code{row_pcoord()} and \code{col_pcoord()} retrieve the coordinates of
the rows and columns of a \code{\link[ca:ca]{ca}} object across all dimensions.
The functions \code{xlim4ca()} and \code{ylim4ca()} return the range of values for the
first and second dimensions.
}
\details{
In the output of \code{row_pcoord()}, each row corresponds to a row from the dataframe
that \code{\link[ca:ca]{ca::ca()}} was applied to, and each column corresponds to a principal component.
In the output of \code{col_pcoord()}, each row corresponds to a column from the dataframe
that \code{\link[ca:ca]{ca::ca()}} was applied to, and each column corresponds to a principal component.
}
\section{Functions}{
\itemize{
\item \code{row_pcoord()}: Retrieve row principal coordinates for all dimensions

\item \code{col_pcoord()}: Retrieve column principal coordinates for all dimensions

\item \code{xlim4ca()}: Return range of first dimension for plotting

\item \code{ylim4ca()}: Return range of second dimension for plotting

}}
\examples{

# traditional biplot from {ca}

library(ca)
data("author")
author_ca <- ca(author)
plot(author_ca)

# alternative plot with {mclm} tools
r_pc <- row_pcoord(author_ca)
c_pc <- col_pcoord(author_ca)
xlim <- xlim4ca(author_ca)
ylim <- ylim4ca(author_ca)
author_names <- as.factor(gsub(
                              "^.*?\\\\((.*?)\\\\)$", "\\\\1",
                             rownames(author), perl = TRUE))
plot(r_pc[,1], r_pc[,2], pch = 18,
    xlim = xlim, ylim = ylim, xlab = "", ylab = "",
    main = "authors and their alphabet",
    col = as.numeric(author_names))
abline(h = 0, col = "gray", lty = 3)
abline(v = 0, col = "gray", lty = 3)
text(c_pc[,1], c_pc[,2], colnames(author), col = "gray")
legend("topright",
       legend = levels(author_names),
       pch = rep(18, length(levels(author_names))),
       col = 1:length(levels(author_names)),
       title = "authors")
}
