% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_classes.R
\name{summary.mcc}
\alias{summary.mcc}
\title{Summary method for \code{mcc} objects}
\usage{
\method{summary}{mcc}(object, ...)
}
\arguments{
\item{object}{An \code{mcc} object}

\item{...}{Additional arguments (currently unused)}
}
\value{
A summary object with class \code{summary.mcc}
}
\description{
Summary method for \code{mcc} objects
}
\examples{
# Attach dplyr
library(dplyr)
# Create sample data with recurrent events
df <- data.frame(
  id = c(1, 2, 3, 4, 4, 4, 4, 5, 5),
  time = c(8, 1, 5, 2, 6, 7, 8, 3, 3),
  cause = c(0, 0, 2, 1, 1, 1, 0, 1, 2)
 ) |>
  arrange(id, time)  # Sort the data by id and time

# Calculate MCC using the equation method (default)
mcc_eq <- mcc(df, id_var = "id", time_var = "time", cause_var = "cause")

summary(mcc_eq)

# Calculate MCC using the sum of cumulative incidence method
mcc_sci <- mcc(
  df,
  id_var = "id",
  time_var = "time",
  cause_var = "cause",
  method = "sci"
)

summary(mcc_sci)

# Clean up
rm(df, mcc_eq, mcc_sci)

}
