% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_classes.R
\name{is_mcc}
\alias{is_mcc}
\title{Check if object is an \code{mcc} result}
\usage{
is_mcc(x)
}
\arguments{
\item{x}{An object to test}
}
\value{
TRUE if x is an \code{mcc} object, FALSE otherwise
}
\description{
Check if object is an \code{mcc} result
}
\examples{
# Create sample data
library(dplyr)
df <- data.frame(
  id = c(1, 2, 3, 4, 4, 4, 4, 5, 5),
  time = c(8, 1, 5, 2, 6, 7, 8, 3, 3),
  cause = c(0, 0, 2, 1, 1, 1, 0, 1, 2)
 ) |>
  arrange(id, time)

# Calculate MCC
mcc_result <- mcc(df, "id", "time", "cause")

# Test if it's an MCC object
is_mcc(mcc_result)  # TRUE

# Clean up
rm(df, mcc_result)

}
