% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate.R
\name{add_matrix}
\alias{add_matrix}
\title{Add matrices to the \code{matrixset} object}
\usage{
add_matrix(.ms, ...)
}
\arguments{
\item{.ms}{A \code{matrixset} object.}

\item{...}{A single list of matrices (must be a named list), or
individual matrices, e.g. \code{mat1 = m1}, \code{mat2 = m2}, etc.
\code{NULL} elements are accepted. This allows to create a
placeholder that can be filled later on.}
}
\value{
A \code{matrixset} with updated matrices.
}
\description{
Matrices to add must be of the same dimension and dimnames as \code{.ms}.

Either a named list of matrices can be supplied, or matrices can be specified
separaely.
}
\examples{
m1 <- matrix(1:60, 20, 3)
dimnames(m1) <- dimnames(student_results)
m2 <- matrix(101:160, 20, 3)
dimnames(m2) <- dimnames(student_results)

ms <- add_matrix(student_results, m1=m1, m2=m2)
ms2 <- add_matrix(student_results, list(m1=m1, m2=m2))

}
